// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Slate/SlateTextures.h"

class FNhnCefWebView;
class FNhnWebViewImeHandler;

class FNhnWebViewViewport final : public ISlateViewport
{
public:
    FNhnWebViewViewport();
    virtual ~FNhnWebViewViewport() override;

    void SetWebView(const int32 InWebIndex, const TSharedPtr<SWidget>& ParentWidget);

    virtual FIntPoint GetSize() const override;
    virtual void OnDrawViewport(const FGeometry& AllottedGeometry, const FSlateRect& MyCullingRect, FSlateWindowElementList& OutDrawElements, int32 LayerId, const FWidgetStyle& InWidgetStyle, bool bParentEnabled) override;
    virtual FSlateShaderResource* GetViewportRenderTargetTexture() const override;
    virtual void Tick(const FGeometry& AllottedGeometry, const double InCurrentTime, const float DeltaTime) override;
    virtual bool RequiresVsync() const override;
    virtual FCursorReply OnCursorQuery(const FGeometry& MyGeometry, const FPointerEvent& CursorEvent) override;
    virtual FReply OnMouseButtonDown(const FGeometry& MyGeometry, const FPointerEvent& MouseEvent) override;
    virtual FReply OnMouseButtonUp(const FGeometry& MyGeometry, const FPointerEvent& MouseEvent) override;
    virtual void OnMouseEnter(const FGeometry& MyGeometry, const FPointerEvent& MouseEvent) override;
    virtual void OnMouseLeave(const FPointerEvent& MouseEvent) override;
    virtual FReply OnMouseMove(const FGeometry& MyGeometry, const FPointerEvent& MouseEvent) override;
    virtual FReply OnMouseWheel(const FGeometry& MyGeometry, const FPointerEvent& MouseEvent) override;
    virtual FReply OnMouseButtonDoubleClick(const FGeometry& InMyGeometry, const FPointerEvent& InMouseEvent) override;
    virtual FReply OnKeyDown(const FGeometry& MyGeometry, const FKeyEvent& InKeyEvent) override;
    virtual FReply OnKeyUp(const FGeometry& MyGeometry, const FKeyEvent& InKeyEvent) override;
    virtual FReply OnKeyChar(const FGeometry& MyGeometry, const FCharacterEvent& InCharacterEvent) override;
    virtual FReply OnFocusReceived(const FFocusEvent& InFocusEvent) override;
    virtual void OnFocusLost(const FFocusEvent& InFocusEvent) override;

    FVector2D GetMousePosition(const FGeometry& MyGeometry, const FPointerEvent& MouseEvent) const;
    static int32 GetKeyboardModifier(const FInputEvent& InputEvent);

    void UpdateMouseCursor(const int32 WebViewUpdateStatus);

    // Ime methods
    static FModifierKeysState SlateModifiersFromCefModifiers(const uint32 Modifiers);
    bool OnUnhandledKeyEvent(const int32 Type, const uint32 Modifiers, const int32 KeyCode, const wchar_t Character);
    void ImeCompositionRangeChanged(const bool bIsRangeChanged) const;
    void SetKeyEvent(const int32 Type, const uint32 Modifiers, const int32 KeyCode, const wchar_t Character);

protected:
    void RenderWebView(TSharedPtr<FNhnCefWebView> WebViewPtr) const;
    
protected:
    int32 WebIndex;
    TSharedPtr<FSlateTexture2DRHIRef, ESPMode::ThreadSafe> TargetTexture;

    bool bIsMouseDown;
    FVector2D MousePosition;
    EMouseCursor::Type CurrentCursorType;

    // Ime
    TSharedPtr<FNhnWebViewImeHandler> Ime;
    TOptional<FKeyEvent> PreviousKeyDownEvent;
    TOptional<FKeyEvent> PreviousKeyUpEvent;
    TOptional<FCharacterEvent> PreviousCharacterEvent;
    bool bIgnoreKeyDownEvent;
    bool bIgnoreKeyUpEvent;
    bool bIgnoreCharacterEvent;

    // Key event
    bool bHasNativeKeyEvent;
    int32 NativeKeyEventType;
    uint32 NativeKeyEventModifiers;
    int32 NativeKeyEventKeyCode;
    wchar_t NativeKeyEventCharacter;
};
