// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "GenericPlatform/ITextInputMethodSystem.h"

class FNhnWebViewImeHandler;

class FNhnWebViewTextInputMethodContext final : public ITextInputMethodContext
{
public:
    static TSharedRef<FNhnWebViewTextInputMethodContext> Create(const TSharedRef<FNhnWebViewImeHandler>& InOwner, const uint32 WebIndex);

    FNhnWebViewTextInputMethodContext(const TSharedRef<FNhnWebViewImeHandler>& InOwner, const uint32 Index);
    virtual ~FNhnWebViewTextInputMethodContext() override;

    void AbortComposition();
    bool UpdateCachedGeometry(const FGeometry& AllottedGeometry);
    bool CEFCompositionRangeChanged(bool bIsRangeChanged) const;

    virtual bool IsComposing() override;

private:
    virtual bool IsReadOnly() override;
    virtual uint32 GetTextLength() override;
    virtual void GetSelectionRange(uint32& BeginIndex, uint32& Length, ECaretPosition& CaretPosition) override;
    virtual void SetSelectionRange(const uint32 BeginIndex, const uint32 Length, const ECaretPosition CaretPosition) override;
    virtual void GetTextInRange(const uint32 BeginIndex, const uint32 Length, FString& OutString) override;
    virtual void SetTextInRange(const uint32 BeginIndex, const uint32 Length, const FString& InString) override;
    virtual int32 GetCharacterIndexFromPoint(const FVector2D& Point) override;
    virtual bool GetTextBounds(const uint32 BeginIndex, const uint32 Length, FVector2D& Position, FVector2D& Size) override;
    virtual void GetScreenBounds(FVector2D& Position, FVector2D& Size) override;
    virtual TSharedPtr<FGenericWindow> GetWindow() override;
    virtual void BeginComposition() override;
    virtual void UpdateCompositionRange(const int32 InBeginIndex, const uint32 InLength) override;
    virtual void EndComposition() override;
    void ResetComposition();

private:
    uint32 WebIndex;

    TSharedRef<FNhnWebViewImeHandler> Owner;
    TWeakPtr<SWindow> CachedSlateWindow;

    FGeometry CachedGeometry;
    bool bIsComposing;
    int32 CompositionBeginIndex;
    uint32 CompositionLength;

    uint32 SelectionRangeBeginIndex;
    uint32 SelectionRangeLength;
    ECaretPosition SelectionCaretPosition;

    FString CompositionString;
};
