// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"

class ITextInputMethodSystem;
class ITextInputMethodChangeNotifier;
class FNhnWebViewTextInputMethodContext;
class SWidget;

class FNhnWebViewImeHandler : public TSharedFromThis<FNhnWebViewImeHandler>
{
public:
    FNhnWebViewImeHandler();
    ~FNhnWebViewImeHandler();

    void UnbindCefBrowser();
    void SetWebView(TSharedPtr<SWidget> SlateWidget, uint32 InWebIndex);
    void AbortComposition() const;

    void SetFocus(bool bHasFocus) const;
    void UpdateCachedGeometry(const FGeometry& AllottedGeometry) const;

    void CEFCompositionRangeChanged(const bool bIsRangeChanged) const;
    void UpdateImeHandler(const bool bIsImeChanged);

    void BindInputMethodSystem(ITextInputMethodSystem* InTextInputMethodSystem);
    void UnbindInputMethodSystem();

    void InitContext();
    void DeactivateContext() const;
    void DestroyContext();

    bool HandleFocusChangedMessage(const bool bIsEditable);
    void UpdateFocusChangedContext();

private:
    int32 WebIndex;
    TSharedPtr<SWidget> InternalBrowserSlateWidget;

    ITextInputMethodSystem* TextInputMethodSystem;
    TSharedPtr<FNhnWebViewTextInputMethodContext> TextInputMethodContext;
    TSharedPtr<ITextInputMethodChangeNotifier> TextInputMethodChangeNotifier;

    bool bIsInitContext;
    bool bIsDeactivateContext;
    
    friend class FNhnWebViewTextInputMethodContext;
};
