#pragma once

#include "CoreMinimal.h"

namespace CefBgType
{
    static constexpr int32 Opaque = 0x100;
    static constexpr int32 Transparent = 0x200;
}

namespace CefDownloadCompleteOption
{
    static constexpr int32 OpenFolder = 1;
    static constexpr int32 OpenFile = 2;
}

namespace CefInputElementType
{
    static constexpr int32 Password = 1;
    static constexpr int32 Else = 100;
}

namespace CefJsDialogType
{
    static constexpr int32 Alert = 0;
    static constexpr int32 Confirm = 1;
    static constexpr int32 Prompt = 2;
}

namespace CefPopupType
{
    static constexpr int32 Popup = 0x10;
    static constexpr int32 Redirect = 0x20;
    static constexpr int32 Block = 0x40;
    static constexpr int32 PassInfo = 0x80;
}

namespace CefWebCursorType
{
    static constexpr int32 Pointer = 1;
    static constexpr int32 Cross = 2;
    static constexpr int32 Hand = 3;
    static constexpr int32 IBeam = 4;
    static constexpr int32 Wait = 5;
    static constexpr int32 Help = 6;
    static constexpr int32 EastResize = 7;
    static constexpr int32 NorthResize = 8;
    static constexpr int32 NortheastResize = 9;
    static constexpr int32 NorthwestResize = 10;
    static constexpr int32 SouthResize = 11;
    static constexpr int32 SouthwestResize = 13;
    static constexpr int32 SoutheastResize = 12;
    static constexpr int32 WestResize = 14;
    static constexpr int32 NorthSouthResize = 15;
    static constexpr int32 EastWestResize = 16;
    static constexpr int32 NortheastSouthwestResize = 17;
    static constexpr int32 NorthwestSoutheastResize = 18;
    static constexpr int32 ColumnResize = 19;
    static constexpr int32 RowResize = 20;
    static constexpr int32 MiddlePanning = 21;
    static constexpr int32 EastPanning = 22;
    static constexpr int32 NorthPanning = 23;
    static constexpr int32 NortheastPanning = 24;
    static constexpr int32 NorthwestPanning = 25;
    static constexpr int32 SouthPanning = 26;
    static constexpr int32 SoutheastPanning = 27;
    static constexpr int32 SouthwestPanning = 28;
    static constexpr int32 WestPanning = 29;
    static constexpr int32 Move = 30;
    static constexpr int32 VerticalText = 31;
    static constexpr int32 Cell = 32;
    static constexpr int32 Contextmenu = 33;
    static constexpr int32 Alias = 34;
    static constexpr int32 Progress = 35;
    static constexpr int32 NoDrop = 36;
    static constexpr int32 Copy = 37;
    static constexpr int32 None = 38;
    static constexpr int32 NotAllowed = 39;
    static constexpr int32 ZoomIn = 40;
    static constexpr int32 ZoomOut = 41;
    static constexpr int32 Grab = 42;
    static constexpr int32 Grabbing = 43;
    static constexpr int32 Custom = 44;
}

namespace CefWebInput
{
    static constexpr int32 None = 0;
    static constexpr int32 Event = 0xF0;
    static constexpr int32 Press = 0x10;
    static constexpr int32 Release = 0x20;
    static constexpr int32 Move = 0x30;
    static constexpr int32 Scroll = 0x40;
    static constexpr int32 Character = 0x50;
    static constexpr int32 Focus = 0x60;
    static constexpr int32 Lost = 0x70;
    static constexpr int32 Modifier = 0xF00;
    static constexpr int32 Shift = 0x100;
    static constexpr int32 Alt = 0x200;
    static constexpr int32 Ctrl = 0x400;
    static constexpr int32 MousePressing = 0x100;
    static constexpr int32 Mask = 0xF000;
    static constexpr int32 Mouse = 0x1000;
    static constexpr int32 Keyboard = 0x2000;
    static constexpr int32 JsDialog = 0x4000;
}

namespace CefWebNavigationDirection
{
    static constexpr int32 Home = 0;
    static constexpr int32 Back = 1;
    static constexpr int32 Forward = 2;
}

namespace CefWebOption
{
    static constexpr int32 InverseColor = 0x1;
    static constexpr int32 InverseY = 0x2;
}

namespace CefWebUpdateStatus
{
    static constexpr int32 Invalid = -1;
    static constexpr int32 None = 0;
    static constexpr int32 Available = 0x100;
    static constexpr int32 Browsable = 0x200;
    static constexpr int32 Focused = 0x400;
    static constexpr int32 JsDialog = 0x800;
    static constexpr int32 Error = 0x1000;
    static constexpr int32 Title = 0x2000;
    static constexpr int32 PopupBlock = 0x4000;
    static constexpr int32 InputFocus = 0x8000;
    static constexpr int32 LoadEnd = 0x100000;
    static constexpr int32 PassPopupInfo = 0x200000;
    static constexpr int32 CursorMask = 0xFF;
}
