// Copyright Epic Games, Inc. All Rights Reserved.

#pragma once

#include "CoreMinimal.h"

DECLARE_DELEGATE_OneParam(FCefJsDialogClickDelegate, bool);

namespace NhnCef
{
    struct FWebViewInfo
    {
        int32 WebIndex;
        UTexture2D* Texture;
    };

    struct FPopupBlock
    {
        FString Message;
    };

    struct FJsDialog
    {
        FString Message;
        int32 Type;
        FCefJsDialogClickDelegate ClickButtonDelegate;
    };

    struct FLoadEnd
    {
        FString Url;
    };

    struct FPassPopupInfo
    {
        FString Name;
        FString Url;
        int32 Left;
        int32 Top;
        int32 Width;
        int32 Height;
        bool bMenubar;
        bool bStatus;
        bool bToolbar;
        bool bScrollbars;
    };

    struct FWebViewStatus
    {
        int32 WebIndex;
        int32 Status;
        FPopupBlock PopupBlock;
        FJsDialog JSDialog;
        FLoadEnd LoadEnd;
        FPassPopupInfo PassPopupInfo;
    };
}