// Copyright Epic Games, Inc. All Rights Reserved.

#pragma once

#include "CoreMinimal.h"
#include "NhnCefWebViewCallback.h"

namespace NhnCef
{
    struct FPopupOption
    {
        int32 Type;
        FString BlockMessage;
    };
    
    struct FCreateParams
    {
        bool bUseTexture;
        FVector2D Position;
        FVector2D Size;
        int32 BgType;
        FPopupOption PopupOption;
        FString PopupIcon;
    };
    
    struct FShowParams
    {
        int32                            Index;
        FString                          Url;
        bool                             bShowScrollBar;
        FCefWebViewResultDelegate        OpenDelegate;
        FNhnCefWebViewUrlDelegate        UrlDelegate         = FNhnCefWebViewUrlDelegate();
        FNhnCefWebViewTitleDelegate      TitleDelegate       = FNhnCefWebViewTitleDelegate();
        FNhnCefWebViewInputFocusDelegate InputFocusDelegate  = FNhnCefWebViewInputFocusDelegate();
        FCefWebViewStatusDelegate        StatusDelegate      = FCefWebViewStatusDelegate();
    };
}
