﻿using System.IO;
using NHNCloud.Gamebase;
using UnrealBuildTool;

public class GPIAP : ModuleRules
{
    public GPIAP(ReadOnlyTargetRules Target) : base(Target)
    {
        Type = ModuleType.External;

        if (Target.Platform == UnrealTargetPlatform.Win64)
        {
            PublicDefinitions.Add("WITH_GP_IAP_SDK=1");
            
            string platformThirdPartyPath = Path.GetFullPath(Path.Combine(ModuleDirectory, Target.Platform.ToString()));
            string platformBinariesPath = Path.GetFullPath(Path.Combine(PluginDirectory, "Binaries", Target.Platform.ToString()));
            
            RuntimeDependencies.Add(Path.Combine(platformBinariesPath, "IapSDK.dll"), Path.Combine(platformThirdPartyPath, "IapSDK.dll"));
            PublicDelayLoadDLLs.Add("IapSDK.dll");
        }
        else
        {
            PublicDefinitions.Add("WITH_GP_IAP_SDK=0");
            Logger.LogInfo("[GPIAP] IAP not supported on this platform");
        }
    }
}