﻿#pragma once

#include "GamebaseBaseTypes.h"
#include "GamebaseInternalDataPointer.h"
#include "GamebaseLaunchingTypes.h"

class FGamebaseSessionTicketClient;

struct GAMEBASESTANDALONE_API FGamebaseAuthConfiguration
{
    using FIdPInfo = FGamebaseLaunchingInfo::FLaunching::FApp::FIdp;

    FString ProviderName;
    FString GamebaseLoginUrl;
    FIdPInfo LaunchingIdpInfo;
    
    TOptional<FString> GuestAccessToken;
    TOptional<FString> GbIdClientId;
    TOptional<FString> SessionTicketId;

    FGamebaseVariantMap UserAdditionalInfo;

    FGamebaseInternalDataPtr InternalData;
    
    TWeakPtr<FGamebaseSessionTicketClient> SessionTicketClient;
};

namespace GamebaseAuthMemberWebLoginParameter
{
    const FName SocialNetworkingServiceCode("socialNetworkingServiceCode");
    const FName ClientId("clientId");
    const FName SvcUrl("svcUrl");
    const FName SocialNetworkingServiceSubCode("socialNetworkingServiceSubCode");
    const FName ServiceProviderCode("serviceProviderCode");
    const FName IdType("idType");
    const FName IsMobile("isMobile");
    const FName State("state");
    const FName SnsCd("snsCd");
    const FName CodeChallenge("codeChallenge");
    const FName AuthorizationProtocol("authorizationProtocol");
    const FName AccessType("accessType");
    const FName Scope("scope");
}

using FGamebaseLoginSystemPtr = TSharedPtr<class IGamebaseAuthMemberLoginSystem, ESPMode::ThreadSafe>;