﻿#include "GamebaseWebViewInternalSystem.h"

#if WITH_GAMEBASE_WEBVIEW_GAMEBASE_PLUGIN

#include "GamebaseDebugLogger.h"
#include "GamebaseErrorCode.h"
#include "NhnWebViewSubsystem.h"
#include "NhnWebViewConfiguration.h"
#include "WebView/GamebaseWebViewConstants.h"
#include "WebView/GamebaseWebViewOpenParams.h"

void FGamebaseWebViewInternalSystem::Open(const FGamebaseWebViewOpenParams& Params)
{
    if (OwningGameInstance.IsValid() == false)
    {
        GAMEBASE_LOG_GLOBAL_WARNING("OwningGameInstance is invalid.");
        Params.CloseCallback(FGamebaseErrorResult(FGamebaseError(
            GamebaseErrorCode::UNREAL_GET_ENGINE_INFO_ERROR,
            TEXT("OwningGameInstance is invalid."),
            GamebaseWebView::Domain)));
        return;
    }
    
    FNhnWebViewConfiguration CefConfiguration;
    if (Params.Navigation.IsSet())
    {
        const auto& NavigationInfo = Params.Navigation.GetValue();
        CefConfiguration.NavigationBarVisible = true;
        CefConfiguration.Title = NavigationInfo.Title;
        CefConfiguration.TitleColor = NavigationInfo.TitleColor;
        CefConfiguration.NavigationBarColor = NavigationInfo.BarColor;
        CefConfiguration.NavigationBarIconTintColor = NavigationInfo.IconTintColor;
        CefConfiguration.BackButtonVisible = NavigationInfo.bIsBackButton;
        CefConfiguration.ForwardButtonVisible = NavigationInfo.bIsForwardButton;
        CefConfiguration.NavigationButtonsAlwaysVisible = NavigationInfo.bVisibleButtons;
        CefConfiguration.NavigationBarHeight = NavigationInfo.BarHeight;
    }
    else
    {
        CefConfiguration.NavigationBarVisible = false;
    }

    CefConfiguration.BackgroundColor = Params.BackgroundColor; 
    
    CefConfiguration.ViewportSize = Params.ViewportSize;
    switch (Params.Type)
    {
        case FGamebaseWebViewOpenParams::Window:
        default:
            CefConfiguration.Type = Window;
            break;
        case FGamebaseWebViewOpenParams::FloatingPopup:
            CefConfiguration.Type = FloatingPopup;
            break;
    }
    
    FNhnWebViewEventListener EventListener;
    EventListener.SchemeList = Params.SchemeList;
    EventListener.SchemeCallback = FNhnWebViewSchemeDelegate::CreateLambda([EventCallback = Params.EventCallback](const FString& Scheme, const FNhnWebViewError& Error)
    {
        EventCallback(FGamebaseWebviewEventResult(Scheme));
    });
    EventListener.CloseCallback = FNhnWebViewErrorDelegate::CreateLambda([CloseCallback = Params.CloseCallback](const FNhnWebViewError& Error)
    {
        CloseCallback(FGamebaseErrorResult());
    });
    
    if (const UNhnWebViewSubsystem* Subsystem = OwningGameInstance->GetSubsystem<UNhnWebViewSubsystem>())
    {
        Subsystem->ShowWebView(Params.Url, CefConfiguration, EventListener);
    }
}

void FGamebaseWebViewInternalSystem::Close()
{
    if (const UNhnWebViewSubsystem* Subsystem = OwningGameInstance->GetSubsystem<UNhnWebViewSubsystem>())
    {
        Subsystem->CloseWebView();
    }
}

#endif