﻿#include "GamebaseWebViewManager.h"

#include "System/GamebaseWebViewSelector.h"

FGamebaseWebViewManager::FGamebaseWebViewManager(const TWeakObjectPtr<UGameInstance> GameInstance)
    : OwningGameInstance(GameInstance)
    , Viewer(MakeUnique<FGamebasePlatformWebViewSystem>(GameInstance))
{
}


void FGamebaseWebViewManager::Open(const FGamebaseWebViewOpenParams& Params)
{
    if (Viewer.IsValid() == false)
    {
        return;
    }
    
    Viewer->Open(Params);
}

void FGamebaseWebViewManager::Close()
{
    if (Viewer.IsValid() == false)
    {
        return;
    }

    Viewer->Close();
}