﻿#pragma once

#include "CoreMinimal.h"
#include "GamebaseJsonSerializerMacros.h"
#include "Server/GamebaseServerPushResponse.h"

struct FGamebaseHeaderResponse final : FGamebaseJsonSerializable
{
    struct FTraceError final : FGamebaseJsonSerializable
    {
        FString ApiId;
        FString ApiVersion;
        FString AppId;
        FString GatewayApiVersion;
        FString ProductId;
        FString ThrowPoint;
        int32 ThrowPointErrorCode;
        int64 TrackingTime;
        FString Uri;
        int32 ResultCode;
        FString ResultMessage;
        FString InnerTraceError;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("apiId", ApiId);
            GAMEBASE_JSON_SERIALIZE("apiVersion", ApiVersion);
            GAMEBASE_JSON_SERIALIZE("appId", AppId);
            GAMEBASE_JSON_SERIALIZE("gatewayApiVersion", GatewayApiVersion);
            GAMEBASE_JSON_SERIALIZE("productId", ProductId);
            GAMEBASE_JSON_SERIALIZE("throwPoint", ThrowPoint);
            GAMEBASE_JSON_SERIALIZE("throwPointErrorCode", ThrowPointErrorCode);
            GAMEBASE_JSON_SERIALIZE("trackingTime", TrackingTime);
            GAMEBASE_JSON_SERIALIZE("uri", Uri);
            GAMEBASE_JSON_SERIALIZE("resultCode", ResultCode);
            GAMEBASE_JSON_SERIALIZE("resultMessage", ResultMessage);
            GAMEBASE_JSON_SERIALIZE_RAW_JSON_STRING("traceError", InnerTraceError);
        END_GAMEBASE_JSON_SERIALIZER
    };

    bool bIsSuccessful = false;
    int32 ResultCode;
    FString ResultMessage;
    FString TransactionId;
    TOptional<FTraceError> TraceError;
    TOptional<GamebaseServerPush::FServerPush> ServerPush;
    
    BEGIN_GAMEBASE_JSON_SERIALIZER
        GAMEBASE_JSON_SERIALIZE("isSuccessful", bIsSuccessful);
        GAMEBASE_JSON_SERIALIZE("resultCode", ResultCode);
        GAMEBASE_JSON_SERIALIZE("resultMessage", ResultMessage);
        GAMEBASE_JSON_SERIALIZE("transactionId", TransactionId);
        GAMEBASE_JSON_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE("traceError", TraceError);
        GAMEBASE_JSON_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE("serverPush", ServerPush);
    END_GAMEBASE_JSON_SERIALIZER
};

struct FGamebaseWebSocketResponse final : FGamebaseJsonSerializable
{
    FGamebaseHeaderResponse Header;
    FString ServerPush;
    FString ServerPushPopup;
    FString Result;
    FString ErrorExtras;
    FString TransactionId;
    FString ApiId;
    
    FString OriginData;

    BEGIN_GAMEBASE_JSON_SERIALIZER
        GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
        GAMEBASE_JSON_SERIALIZE_RAW_JSON_STRING("errorExtras", ErrorExtras);
        GAMEBASE_JSON_SERIALIZE_RAW_JSON_STRING("serverPush", ServerPush);
        GAMEBASE_JSON_SERIALIZE_RAW_JSON_STRING("popup", ServerPushPopup);
        GAMEBASE_JSON_SERIALIZE("result", Result);
    END_GAMEBASE_JSON_SERIALIZER
};