#pragma once

#include "CoreMinimal.h"
#include "GamebaseJsonSerializerMacros.h"
#include "WebSocket/GamebaseWebSocketResponse.h"

namespace GamebaseTerms
{
    struct FQueryTermsResponse final : FGamebaseJsonSerializable
    {
        struct FTerms final : FGamebaseJsonSerializable
        {
            struct FContent final : FGamebaseJsonSerializable
            {
                int32 TermsContentSeq;
                bool bAgreed;
                bool bRequired;
                FString Name;
                FString AgreePush;
                int32 Node1DepthPosition;
                int32 Node2DepthPosition;
                FString DetailPageUrl;
                
                BEGIN_GAMEBASE_JSON_SERIALIZER
                    GAMEBASE_JSON_SERIALIZE("termsContentSeq", TermsContentSeq);
                    GAMEBASE_JSON_SERIALIZE("agreed", bAgreed);
                    GAMEBASE_JSON_SERIALIZE("required", bRequired);
                    GAMEBASE_JSON_SERIALIZE("name", Name);
                    GAMEBASE_JSON_SERIALIZE("agreePush", AgreePush);
                    GAMEBASE_JSON_SERIALIZE("node1DepthPosition", Node1DepthPosition);
                    GAMEBASE_JSON_SERIALIZE("node2DepthPosition", Node2DepthPosition);
                    GAMEBASE_JSON_SERIALIZE("detailPageUrl", DetailPageUrl);
                END_GAMEBASE_JSON_SERIALIZER
            };

            int32 TermsSeq;
            FString TermsVersion;
            FString TermsCountryType;
            TArray<FContent> Contents;
        
            BEGIN_GAMEBASE_JSON_SERIALIZER
                GAMEBASE_JSON_SERIALIZE("termsSeq", TermsSeq);
                GAMEBASE_JSON_SERIALIZE("termsVersion", TermsVersion);
                GAMEBASE_JSON_SERIALIZE("termsCountryType", TermsCountryType);
                GAMEBASE_JSON_SERIALIZE_ARRAY_SERIALIZABLE("contents", Contents, FContent);
            END_GAMEBASE_JSON_SERIALIZER
        };
        
        FGamebaseHeaderResponse Header;
        FTerms Terms;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("terms", Terms);
        END_GAMEBASE_JSON_SERIALIZER
    };

    struct FUpdateTermsResponse final : FGamebaseJsonSerializable
    {
        FGamebaseHeaderResponse Header;

        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
        END_GAMEBASE_JSON_SERIALIZER
    };
}
