﻿#pragma once

#include "CoreMinimal.h"
#include "WebSocket/GamebaseWebSocketRequest.h"

namespace GamebaseTerms
{
    struct FQueryParameters final : FGamebaseBaseParameter
    {
        FString UserId;
        FString UsimCountryCode;
        FString DeviceCountryCode;
        FString DeviceLanguage;
        FString DisplayLanguage;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_STRING("userId", UserId);
            GAMEBASE_JSON_SERIALIZE_STRING("usimCountryCode", UsimCountryCode);
            GAMEBASE_JSON_SERIALIZE_STRING("deviceCountryCode", DeviceCountryCode);
            GAMEBASE_JSON_SERIALIZE_STRING("deviceLanguage", DeviceLanguage);
            GAMEBASE_JSON_SERIALIZE_STRING("displayLanguage", DisplayLanguage);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FUpdateParameters final : FGamebaseBaseParameter
    {
        FString UserId;
        int32 TermsSeq;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_STRING("userId", UserId);
            GAMEBASE_JSON_SERIALIZE("termsSeq", TermsSeq);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FUpdatePayload final : FGamebaseBasePayload
    {
        struct FContent final : FGamebaseJsonSerializable
        {
            int32 TermsContentSeq;
            bool bAgreed;
            
            BEGIN_GAMEBASE_JSON_SERIALIZER
                GAMEBASE_JSON_SERIALIZE("termsContentSeq", TermsContentSeq);
                GAMEBASE_JSON_SERIALIZE("agreed", bAgreed);
            END_GAMEBASE_JSON_SERIALIZER
        };

        TArray<FContent> Contents;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_ARRAY_SERIALIZABLE("contents", Contents, FContent);
        END_GAMEBASE_JSON_SERIALIZER
    };
}