#pragma once

#include "CoreMinimal.h"
#include "GamebaseJsonSerializerMacros.h"

namespace GamebaseServerPush
{
    struct FServerPush final : FGamebaseJsonSerializable
    {
        FString Type;
        FString Version;
        FString Stamp;
        bool Disconnect;
        bool StopHeartbeat;
        bool Logout;
        bool Popup;

        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("type", Type);
            GAMEBASE_JSON_SERIALIZE("version", Version);
            GAMEBASE_JSON_SERIALIZE("stamp", Stamp);
            GAMEBASE_JSON_SERIALIZE("disconnect", Disconnect);
            GAMEBASE_JSON_SERIALIZE("stopHeartbeat", StopHeartbeat);
            GAMEBASE_JSON_SERIALIZE("logout", Logout);
            GAMEBASE_JSON_SERIALIZE("popup", Popup);
        END_GAMEBASE_JSON_SERIALIZER
    };
        
    struct FServerPushPopup final : FGamebaseJsonSerializable
    {
        struct FMessage final : FGamebaseJsonSerializable
        {
            FString Title;
            FString Message;
                
            BEGIN_GAMEBASE_JSON_SERIALIZER
                GAMEBASE_JSON_SERIALIZE("title", Title);
                GAMEBASE_JSON_SERIALIZE("message", Message);
            END_GAMEBASE_JSON_SERIALIZER
        };
            
        FString DefaultLanguage;
        TMap<FString, FMessage> Messages;
            
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("userId", DefaultLanguage);
            GAMEBASE_JSON_SERIALIZE_MAP_SERIALIZABLE("messages", Messages, FMessage);
        END_GAMEBASE_JSON_SERIALIZER
    };
}

using FGamebaseServerPushPopupInfo = GamebaseServerPush::FServerPushPopup;