#pragma once

namespace GamebaseServerErrorCode
{
    /**
     * Common
     */
    constexpr int32 TypeMismatch = -4000001;
    constexpr int32 IllegalArgument = -4000002;
    constexpr int32 HttpMessageNotReadable = -4000003;
    constexpr int32 MissingServletRequestParameter = -4000004;
    constexpr int32 MethodArgumentNotValid = -4000005;
    constexpr int32 MethodArgumentTypeMismatch = -4000006;
    constexpr int32 FadeoutRequest = -4000007;                   //-TODO: Unity 확인 필요
    constexpr int32 ParameterLengthExceeded = -4000008;          //-TODO: Unity 확인 필요
    
    constexpr int32 InvalidAppId = -4010001;
    constexpr int32 InvalidAppKey = -4010002;
    constexpr int32 NotAuthenticated = -4010003;
    constexpr int32 InvalidSecretKey = -4010004;

    constexpr int32 MediaTypeNotSupported = -4060001;
    
    constexpr int32 DuplicateKey = -4090001;
    constexpr int32 DuplicateName = -4090002;
    constexpr int32 DuplicateEntry = -4090003;
    //constexpr int32 MediaTypeNotSupported = -4090004;
    
    constexpr int32 UnknownSystem = -5000001;
    constexpr int32 RemoteSystem = -5000002;
    
    /**
     * Lighthouse
     */
    constexpr int32 LightHouse_NotAuthenticated = -4010101;
    constexpr int32 LightHouse_NoSuchRequestAPI = -4040101;
    constexpr int32 LightHouse_JSONParsingError = -4150101;
    constexpr int32 LightHouse_GatewayConnectionError = -5000101;
    
    /**
     * Gateway
     */
    constexpr int32 Gateway_InvalidMember = -4010204;
    constexpr int32 Gateway_BannedMember = -4010205;
    constexpr int32 Gateway_JSONParsingError = -4000201;
    constexpr int32 Gateway_MissingRequestParameter = -4000202;
    constexpr int32 Gateway_InvalidAppID = -4010202;
    constexpr int32 Gateway_InvalidAccessToken = -4010203;
    constexpr int32 Gateway_TTLExpiredOrInvalidSessionTicketId = -4010211;
    constexpr int32 Gateway_IdpLoginFailure = -4010212;
    constexpr int32 Gateway_ProductDataNotFound = -4040201;
    constexpr int32 Gateway_InvalidAppType = -4120201;
    constexpr int32 Gateway_RequestAPINotFound = -4040202;
    constexpr int32 Gateway_LoggedInIdpCouldNotDeleted = -4050201;
    constexpr int32 Gateway_LoginInProgress = -4090201;
    constexpr int32 Gateway_UnknownSystem = -5000201;
    constexpr int32 Gateway_RequestWorkerError = -5000202;
    constexpr int32 Gateway_WrongSessionTicketError = -5000212;
    constexpr int32 Gateway_QueueTimeOut = -5040201;
    constexpr int32 Gateway_QueueCapacityFull = -5040202;
    constexpr int32 Gateway_GBLncSystemError = -5100201;
    constexpr int32 Gateway_GBIDSystemError = -5110201;

    /**
     * Member
     */
    constexpr int32 Member_ForcingMappingTicketNotExist = -4040404;
    constexpr int32 Member_ConsumedForcingMappingTicket = -4100404;
    constexpr int32 Member_ExpiredForcingMappingTicket = -4100405;
    constexpr int32 Member_IdpMissMatchForForcingMapping = -4000410;
    constexpr int32 Member_AuthkeyMissMatchForForcingMapping = -4000411;
    
    constexpr int32 Member_CannotTemporaryWithdraw = -4130404;
    constexpr int32 Member_NotTemporaryWithdraw = -4130402;

    /// <summary>
    /// TAP-ID ClientId 정보가 존재하지 않음
    /// </summary>
    constexpr int32 LAUNCHING_NOT_EXIST_CLIENT_ID = -4040301;

    /// <summary>
    /// 등록되지 않은 App(TC Project)
    /// </summary>
    constexpr int32 LAUNCHING_UNREGISTERED_APP = -4040302;

    /// <summary>
    /// 등록되지 않은 Client
    /// </summary>
    constexpr int32 LAUNCHING_UNREGISTERED_CLIENT = -4040303;

    /// <summary>
    /// AppId를 잘못 입력했을 때
    /// </summary>
    constexpr int32 MEMBER_APP_ID_MISS_MATCH = -4000401;

    /// <summary>
    /// UserId를 잘못 입력 했을 때
    /// </summary>
    constexpr int32 MEMBER_USER_ID_MISS_MATCH = -4000402;

    /// <summary>
    /// 잘못된 회원에 대한 요청일 때
    /// </summary>
    constexpr int32 MEMBER_INVALID_MEMBER = -4000403;

    /// <summary>
    /// 잘못된 Auth에 대한 요청일 때
    /// </summary>
    constexpr int32 MEMBER_INVALID_AUTH = -4000404;

    /// <summary>
    /// 이용 정지된 회원이 로그인 요청을 했을 때
    /// </summary>
    constexpr int32 BANNED_MEMBER_LOGIN = -4000405;

    /// <summary>
    /// addMapping 요청시 대상 authKey가 이용 정지된 사용자와 매핑되어 있을 경우
    /// </summary>
    constexpr int32 AUTHKEY_BELONG_TO_BANNED_MEMBER = -4000406;

    /// <summary>
    /// 존재하지 않거나 탈퇴된 회원에 대한 요청일 때
    /// </summary>
    constexpr int32 MEMBER_NOT_EXIST = -4040401;

    /// <summary>
    /// removeMapping을 호출하였으나 매핑되어 있는 OAuth 계정이 하나 일 때
    /// </summary>
    constexpr int32 MEMBER_LAST_MAPPED_IDP = -4060401;

    /// <summary>
    /// guest 이외에 다른 idPCode 를 가지고 있음 
    /// (guest idPCode 만 가지고 있는 user 가 transfer account 를 발급 받을 수 있음)
    /// </summary>
    constexpr int32 GATEWAY_USER_MUST_HAVE_ONLY_GUEST_IDP = -4120202;

    /// <summary>
    /// 이미 탈퇴된 회원에 대한 요청일 때
    /// </summary>
    constexpr int32 MEMBER_ALREADY_WITHDRAWN = -4100401;

    /// <summary>
    /// transferaccount 계정을 이미 사용한 경우
    /// </summary>
    constexpr int32 MEMBER_TRANSFERACCOUNT_ALREADY_USED = -4100402;

    /// <summary>
    /// 이미 다른 회원과 매핑된 계정에 대한 요청일 때
    /// </summary>
    constexpr int32 MEMBER_ALREADY_MAPPED_MEMBER = -4120401;

    /// <summary>
    /// 이미 다른 IdP와 매핑된 계정에 대한 요청일 때
    /// </summary>
    constexpr int32 MEMBER_ALREADY_MAPPED_IDP = -4120402;

    /// <summary>
    /// 템플릿 이름이 중복 되었을 때
    /// </summary>
    constexpr int32 DUPLICATED_TEMPLATE_NAME = -4120403;

    /// <summary>
    /// 이미 IdP 매핑이 되어 있는 사용자가 guest로 add mapping 시도 시 발생.
    /// </summary>
    constexpr int32 CAN_NOT_ADD_GUEST_IDP = -4120405;

    /// <summary>
    /// 이미 IdP 매핑이 되어 있는 사용자가 guest로 add mapping 시도 시 발생.
    /// </summary>
    constexpr int32 MEMBER_IS_NOT_GUEST = -4120404;

    /// <summary>
    /// block id.
    /// </summary>
    constexpr int32 MEMBER_BLOCK_ID = -4000901;

    /// <summary>
    /// NEOID 에서 계정 생성 또는 조회 실패.
    /// </summary>
    constexpr int32 MEMBER_NEOID_QUERY = -4000920;

    /// <summary>
    /// ID (자동)생성 또는 변경시 알수 없는 오류.
    /// </summary>
    constexpr int32 MEMBER_NEOID_SIGNUP_UNKNOWN = -4000921;

    /// <summary>
    /// 이미 IdP 매핑이 되어 있는 사용자가 guest로 add mapping 시도 시 발생.
    /// </summary>
    constexpr int32 MEMBER_NEOID_QUERY_INFO = -4000922;

    /// <summary>
    /// 이미 IdP 매핑이 되어 있는 사용자가 guest로 add mapping 시도 시 발생.
    /// </summary>
    constexpr int32 MEMBER_NEOID_CREATE_PASSWORD = -4000923;

    /// <summary>
    /// 로그인시 알수 없는 오류.
    /// </summary>
    constexpr int32 MEMBER_NEOID_CHECK_PASSWORD_UNKNOWN = -4000924;

    /// <summary>
    /// 메뉴얼로 ID 변경시 중복 ID인 경우.
    /// </summary>
    constexpr int32 MEMBER_NEOID_SIGNUP_ALREADY_EXIST_ID = -4000925;

    /// <summary>
    /// 로그인시 ID 가 존재하지 않을 때.
    /// </summary>
    constexpr int32 MEMBER_NEOID_CHECK_PASSWORD_NOT_EXIST_ID = -4040920;

    /// <summary>
    /// 로그인시 PW 잘못 입력.
    /// </summary>
    constexpr int32 MEMBER_NEOID_CHECK_PASSWORD_INVALID_PASSWORD = -4000927;

    /// <summary>
    /// NEOID 연결 오류.
    /// </summary>
    constexpr int32 MEMBER_NEOID_CONNECTION = -5110920;

    /// <summary>
    /// 기존에 발급 받은 transferAccount 가 존재하지 않거나, 기간 만료 되었음.
    /// </summary>
    constexpr int32 MEMBER_TRANSFERACCOUNT_EXPIRED = -4100403;

    /// <summary>
    /// transfer account 발급 조건이 설정되어 있지 않음. Console 에서 처음에 설정이 필요 함.
    /// </summary>
    constexpr int32 MEMBER_CONSOLE_NO_CONDITION = -4040901;

    /// <summary>
    /// 동일한 단말기에서 transfer를 요청한 경우.
    /// </summary>
    constexpr int32 MEMBER_SAME_REQUESTOR = -4000409;

    /// <summary>
    /// transfer 요청한 유저에게 발급 transferKey 가 없을 경우.
    /// </summary>
    constexpr int32 MEMBER_TRANSFERACCOUNT_NOT_EXIST = -4040403;

    /// <summary>
    /// GamebaseProductID is not activated.
    /// </summary>
    constexpr int32 PURCHASE_NOT_USED_PRODUCT = -4001001;

    /// <summary>
    /// GamebaseProductID is not exist.
    /// </summary>
    constexpr int32 PURCHASE_NOT_FOUND_PRODUCT_ID = -4001001;
    
    /// <summary>
    /// The terms and conditions information is not registered on the console.
    /// </summary>
    constexpr int32 CANNOT_FIND_DEPLOY_TERMS                       = -4001108;

    /// <summary>
    /// The terms and conditions information corresponding to the device country code is not registered on the console.
    /// </summary>
    constexpr int32 CANNOT_FIND_DEFAULT_TERMS                      = -4001110;

    /// <summary>
    /// The unregistered terms Seq value.
    /// </summary>
    constexpr int32 ILLEGAL_TERMS_SEQUENCE_NUMBER                  = -4001106;
 
    constexpr int32 ILLEGAL_TERMS_CONTENT_SEQUENCE_NUMBER                  = -4001105;
}