﻿#include "GamebaseScheduler.h"

#include "GamebaseDebugLogger.h"

FGamebaseScheduler::FGamebaseScheduler(const float InIntervalTime)
    : IntervalTime(InIntervalTime)
{
}

FGamebaseScheduler::~FGamebaseScheduler()
{
    StopScheduler();
}

void FGamebaseScheduler::StartScheduler()
{
    if (TickDelegateHandle.IsValid())
    {
        GAMEBASE_LOG_GLOBAL_DEBUG("The scheduler was not stopped, but a restart was called.");
        return;
    }
    
    OnStartSchedule();
    
    TickDelegateHandle = GamebaseTicker::AddTicker(FTickerDelegate::CreateRaw(this, &FGamebaseScheduler::Tick), IntervalTime);
}

void FGamebaseScheduler::StopScheduler()
{
    GamebaseTicker::RemoveTicker(TickDelegateHandle);
    TickDelegateHandle.Reset();
    OnStopSchedule();
}

bool FGamebaseScheduler::Tick(float DeltaTime)
{
    OnUpdateSchedule();
    return true;
}