﻿#pragma once

#include "CoreMinimal.h"
#include "WebSocket/GamebaseWebSocketRequest.h"

namespace GamebaseHeartbeat
{
    struct FParameters final : FGamebaseBaseParameter
    {
        FString AppId;

        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_STRING("appId", AppId);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FPayload final : FGamebaseBasePayload
    {
        FString AppId;
        FString UserId;
        FString ClientVersion;
        FString OSCode;
        FString DeviceCountryCode;
        FString UsimCountryCode;
        FString StoreCode;
        FString DeviceModel;
        FString IdpCode;
        FString ThirdIdPCode;
            
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_STRING("appId", AppId);
            GAMEBASE_JSON_SERIALIZE_STRING("userId", UserId);
            GAMEBASE_JSON_SERIALIZE_STRING("clientVersion", ClientVersion);
            GAMEBASE_JSON_SERIALIZE_STRING("osCode", OSCode);
            GAMEBASE_JSON_SERIALIZE_STRING("deviceCountryCode", DeviceCountryCode);
            GAMEBASE_JSON_SERIALIZE_STRING("usimCountryCode", UsimCountryCode);
            GAMEBASE_JSON_SERIALIZE_STRING("storeCode", StoreCode);
            GAMEBASE_JSON_SERIALIZE_STRING("deviceModel", DeviceModel);
            GAMEBASE_JSON_SERIALIZE_STRING("idPCode", IdpCode);
            GAMEBASE_JSON_SERIALIZE_STRING("thirdIdPCode", ThirdIdPCode);
        END_GAMEBASE_JSON_SERIALIZER
    };
}