#pragma once

#include "CoreMinimal.h"
#include "WebSocket/GamebaseWebSocketResponse.h"

namespace GamebasePurchase
{   
    struct FIapProductResponse final : FGamebaseJsonSerializable
    {
        FString MarketItemId;
        FString GamebaseProductId;
        FString GamebaseProductName;
        FString GamebaseProductType;
        bool bIsActive;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("marketItemId", MarketItemId);
            GAMEBASE_JSON_SERIALIZE("gamebaseProductId", GamebaseProductId);
            GAMEBASE_JSON_SERIALIZE("gamebaseProductName", GamebaseProductName);
            GAMEBASE_JSON_SERIALIZE("gamebaseProductType", GamebaseProductType);
            GAMEBASE_JSON_SERIALIZE("isActive", bIsActive);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FIapProductWithMarketItemIdResponse final : FGamebaseJsonSerializable
    {
        FString MarketItemId;
        FString GamebaseProductId;
        FString GamebaseProductName;
        bool bIsActive;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("marketItemId", MarketItemId);
            GAMEBASE_JSON_SERIALIZE("gamebaseProductId", GamebaseProductId);
            GAMEBASE_JSON_SERIALIZE("gamebaseProductName", GamebaseProductName);
            GAMEBASE_JSON_SERIALIZE("isActive", bIsActive);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FGetGamebaseProductsResponse final : FGamebaseJsonSerializable
    {
        FGamebaseHeaderResponse Header;
        TArray<FIapProductWithMarketItemIdResponse> Products;
        TArray<FIapProductWithMarketItemIdResponse> InvalidProducts;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
            GAMEBASE_JSON_SERIALIZE_ARRAY_SERIALIZABLE("products", Products, FIapProductWithMarketItemIdResponse);
            GAMEBASE_JSON_SERIALIZE_ARRAY_SERIALIZABLE("invalidProducts", InvalidProducts, FIapProductWithMarketItemIdResponse);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FGetProductWithGamebaseProductIdResponse final : FGamebaseJsonSerializable
    {
        FGamebaseHeaderResponse Header;
        FIapProductResponse Product;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("product", Product);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FGetProductsWithMarketItemIdResponse final : FGamebaseJsonSerializable
    {
        FGamebaseHeaderResponse Header;
        TArray<FIapProductWithMarketItemIdResponse> Products;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
            GAMEBASE_JSON_SERIALIZE_ARRAY_SERIALIZABLE("products", Products, FIapProductWithMarketItemIdResponse);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FGamebasePayloadResponse final : FGamebaseJsonSerializable
    {
        FString StoreUserId;
        FString GamebaseProductId;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("storeUserId", StoreUserId);
            GAMEBASE_JSON_SERIALIZE("gamebaseProductId", GamebaseProductId);
        END_GAMEBASE_JSON_SERIALIZER
    };
}
