#pragma once

#include "CoreMinimal.h"
#include "WebSocket/GamebaseWebSocketRequest.h"

namespace GamebasePurchase
{
    struct FGetGamebaseProductsParameters final : FGamebaseBaseParameter
    {
        FString StoreCode;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("storeCode", StoreCode);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FGetProductWithGamebaseProductIdParameters final : FGamebaseBaseParameter
    {
        FString StoreCode;
        FString GamebaseProductId;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("storeCode", StoreCode);
            GAMEBASE_JSON_SERIALIZE("gamebaseProductId", GamebaseProductId);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FGetProductsWithMarketItemIdParameters final : FGamebaseBaseParameter
    {
        FString StoreCode;
        FString MarketItemId;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("storeCode", StoreCode);
            GAMEBASE_JSON_SERIALIZE("marketItemId", MarketItemId);
        END_GAMEBASE_JSON_SERIALIZER
    };
}