#include "GamebasePurchaseInternalStatus.h"

#include "GamebaseErrorCode.h"
#include "GamebasePurchaseDefines.h"

FGamebasePurchaseInternalStatus::~FGamebasePurchaseInternalStatus()
{
    Reset();
}

void FGamebasePurchaseInternalStatus::SetError(
    const FGamebaseError* Error)
{
    if (SavedError.IsValid())
    {
        return;
    }
    
    SavedError = MakeShared<FGamebaseError, ESPMode::ThreadSafe>(*Error);
}

void FGamebasePurchaseInternalStatus::Reset()
{
    if (SavedError.IsValid())
    {
        SavedError.Reset();
        SavedError = nullptr;
    }
}

bool FGamebasePurchaseInternalStatus::IsNotInitialized() const
{
    return SavedError.IsValid() && SavedError.Get()->Code == GamebaseErrorCode::PURCHASE_NOT_INITIALIZED;
}

FGamebaseErrorPtr FGamebasePurchaseInternalStatus::GetError() const
{
    if (SavedError.IsValid())
    {
        FGamebaseErrorPtr Error = MakeShared<FGamebaseError, ESPMode::ThreadSafe>(*SavedError);
        Error->Domain = GamebasePurchase::Domain.ToString();

        return Error;
    }

    return nullptr;
}
