#pragma once

#include "GamebaseInternalResult.h"
#include "GamebasePurchaseResponse.h"

using FGamebaseIapProductWithMarketItemIdResponse = GamebasePurchase::FIapProductWithMarketItemIdResponse;
using FGamebaseRequestGetProductWithMarketItemIdResult = FGamebaseInternalResult<TArray<FGamebaseIapProductWithMarketItemIdResponse>>;
using FGamebaseIapProductWithMarketItemIdResponsePtr = TSharedPtr<FGamebaseRequestGetProductWithMarketItemIdResult, ESPMode::ThreadSafe>;

using FGetProductsWithMarketItemIdDelegate = TFunction<void(const TArray<FGamebaseIapProductWithMarketItemIdResponse>&, const FGamebaseError*)>;
using FRequestGetProductWithMarketItemId = TFunction<void(const FString&, const FGetProductsWithMarketItemIdDelegate&)>;

namespace GamebasePurchase
{
    const FName Domain("GamebasePurchase");
    
    FString GetHostUrl(const FString& Zone, const bool bIsSandbox);
}