﻿#pragma once

#include "GamebaseInternalDataPointer.h"
#include "GamebaseInternalResult.h"
#include "GamebasePurchaseDefines.h"
#include "Types/GamebasePurchaseTypes.h"

#if WITH_GAMEBASE_STANDALONE_PURCHASE
#include "GamebaseAdapterCollection.h"
#endif

#if WITH_GAMEBASE_STANDALONE_PURCHASE
class UGamebaseStandalonePurchaseAdapter;
using FGamebasePurchaseAdapterCollection = TGamebaseAdapterCollection<UGamebaseStandalonePurchaseAdapter>;
#endif

struct FGamebasePurchaseConfiguration;
using FGamebasePurchasableReceiptResult = FGamebaseInternalResult<TOptional<FGamebasePurchasableReceipt>>;
using FGamebasePurchasableReceiptListResult = FGamebaseInternalResult<TArray<FGamebasePurchasableReceipt>>;
using FGamebasePurchasableItemListResult = FGamebaseInternalResult<TArray<FGamebasePurchasableItem>>;

class FGamebasePurchaseAdapterManager
{
public:
    using FInitializeFunc = TFunction<void(const FGamebaseError*)>;
    using FReprocessingFunc = TFunction<void(const FGamebaseError*)>;
    using FPurchasableReceiptFunc = TFunction<void(const FGamebasePurchasableReceiptResult&)>;
    using FPurchasableReceiptListFunc = TFunction<void(const FGamebasePurchasableReceiptListResult&)>;
    using FPurchasableItemListFunc = TFunction<void(const FGamebasePurchasableItemListResult&)>;
    
    explicit FGamebasePurchaseAdapterManager(const FGamebaseInternalDataPtr& InternalData);
    ~FGamebasePurchaseAdapterManager();

    bool IsDisable() const;
    
    void SetDebugMode(bool bIsDebugMode);
    
    void Initialize(const FGamebasePurchaseConfiguration& Configuration, const FInitializeFunc& Callback);
    void SetGamebaseUserInfo(const FString& GamebaseUserId, const FString& GamebaseToken);
    void SetDisplayLanguage(const FString& LanguageCode);
    
    void RequestReprocessPurchased(const FString& GamebaseItemListJsonString, const FReprocessingFunc& Callback);
    
    void RequestPurchase(int64 ItemSeq, const FPurchasableReceiptFunc& Callback);
    void RequestPurchase(const GamebasePurchase::FIapProductResponse& ProductData, const FPurchasableReceiptFunc& Callback);
    void RequestPurchase(const GamebasePurchase::FIapProductResponse& ProductData, const FString& Payload, const FPurchasableReceiptFunc& Callback);
    
    void RequestItemListOfNotConsumed(const FGamebasePurchasableConfiguration& Configuration, const FRequestGetProductWithMarketItemId& RequestFunc, const FPurchasableReceiptListFunc& Callback);
    
    void RequestActivatedPurchases(const FPurchasableReceiptListFunc& Callback);
    void RequestActivatedPurchases(const FGamebasePurchasableConfiguration& Configuration, const FPurchasableReceiptListFunc& Callback);

    void RequestItemListPurchasable(const TArray<GamebasePurchase::FIapProductWithMarketItemIdResponse>& Products, const FPurchasableItemListFunc& Callback);
    void RequestItemListAtIAPConsole(const TArray<GamebasePurchase::FIapProductWithMarketItemIdResponse>& Products, const TArray<GamebasePurchase::FIapProductWithMarketItemIdResponse>& InvalidProducts, const FPurchasableItemListFunc& Callback);

    void RequestSubscriptionsStatus(const FGamebasePurchasableConfiguration& Configuration, const FGamebasePurchasableSubscriptionStatusDelegate& Callback);
    void SetPromotionIAPHandler(const FPurchasableReceiptFunc& Callback);
    
private:
    FGamebaseErrorPtr CheckApiAvailability() const;
    
private:
    FGamebaseInternalDataPtr InternalData;
    
#if WITH_GAMEBASE_STANDALONE_PURCHASE
    FGamebasePurchaseAdapterCollection LoadedAdapters;
    TWeakObjectPtr<UGamebaseStandalonePurchaseAdapter> Adapter;
#endif
    
    TMap<FString, FGamebasePurchasableItem> SavedProductList;
};