#pragma once

#include "CoreMinimal.h"
#include "GamebaseJsonSerializerMacros.h"

namespace GamebaseLaunching
{
    struct FErrorExtras final : FGamebaseJsonSerializable
    {
        FString UpdateInfo;
        FString Language;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_RAW_JSON_STRING("updateInfo", UpdateInfo);
            GAMEBASE_JSON_SERIALIZE_RAW_JSON_STRING("language", Language);
        END_GAMEBASE_JSON_SERIALIZER
    };

    struct FLanguageInfo final : FGamebaseJsonSerializable
    {
        FString DeviceLanguage;
        FString DefaultLanguage;
                
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("deviceLanguage", DeviceLanguage);
            GAMEBASE_JSON_SERIALIZE("defaultLanguage", DefaultLanguage);
        END_GAMEBASE_JSON_SERIALIZER
    };
}
