﻿#pragma once

#include "CoreMinimal.h"
#include "WebSocket/GamebaseWebSocketRequest.h"

namespace GamebaseLaunching
{
    struct FParameters final : FGamebaseBaseParameter
    {
        FString AppId;
        FString UserId;
        FString ClientVersion;
        FString SDKVersion;
        FString UUID;
        FString DeviceKey;
        FString OSCode;
        FString OSVersion;
        FString DeviceModel;
        FString DeviceLanguage;
        FString DisplayLanguage;
        FString DeviceCountryCode;
        FString UsimCountryCode;
        FString StoreCode;
        int64 LastCheckedNoticeTime;
        FString TermsVersion;
            
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_STRING("appId", AppId);
            GAMEBASE_JSON_SERIALIZE_STRING("userId", UserId);
            GAMEBASE_JSON_SERIALIZE_STRING("clientVersion", ClientVersion);
            GAMEBASE_JSON_SERIALIZE_STRING("sdkVersion", SDKVersion);
            GAMEBASE_JSON_SERIALIZE_STRING("uuid", UUID);
            GAMEBASE_JSON_SERIALIZE_STRING("deviceKey", DeviceKey);
            GAMEBASE_JSON_SERIALIZE_STRING("osCode", OSCode);
            GAMEBASE_JSON_SERIALIZE_STRING("osVersion", OSVersion);
            GAMEBASE_JSON_SERIALIZE_STRING("deviceModel", DeviceModel);
            GAMEBASE_JSON_SERIALIZE_STRING("deviceLanguage", DeviceLanguage);
            GAMEBASE_JSON_SERIALIZE_STRING("displayLanguage", DisplayLanguage);
            GAMEBASE_JSON_SERIALIZE_STRING("deviceCountryCode", DeviceCountryCode);
            GAMEBASE_JSON_SERIALIZE_STRING("usimCountryCode", UsimCountryCode);
            GAMEBASE_JSON_SERIALIZE_STRING("storeCode", StoreCode);
            GAMEBASE_JSON_SERIALIZE("lastCheckedNoticeTime", LastCheckedNoticeTime);
            GAMEBASE_JSON_SERIALIZE_STRING("termsVersion", TermsVersion);
        END_GAMEBASE_JSON_SERIALIZER
    };
}