﻿#pragma once

#include "GamebaseError.h"
#include "GamebaseImageNoticeResponse.h"
#include "GamebaseImageNoticeTypes.h"
#include "GamebaseStandaloneEventHandler.h"

struct FGamebaseImageNoticeConfiguration;
class FGamebaseImageNoticePreferences;

class FGamebaseImageNoticeViewer
{
    using FGamebaseImageNoticeWeb = GamebaseImageNotice::FResponse::FImageNoticeWeb;
    using FGamebaseImageNoticePageInfo = GamebaseImageNotice::FResponse::FImageNoticeWeb::FImageNoticeInfo;
    using FGamebaseImageNoticePreferencesRef = TSharedRef<FGamebaseImageNoticePreferences>;
    
public:
    explicit FGamebaseImageNoticeViewer(
        const TWeakObjectPtr<UGameInstance> GameInstance,
        const FGamebaseImageNoticePreferencesRef& Preferences,
        const FGamebaseImageNoticeConfiguration& Configuration,
        const FGamebaseImageNoticeWeb& ResponseData,
        const FGamebaseErrorDelegate& CloseCallback,
        const FGamebaseImageNoticeEventDelegate& EventCallback)
        : OwningGameInstance(GameInstance), Preferences(Preferences), Configuration(Configuration), ResponseData(ResponseData), CloseCallback(CloseCallback), EventCallback(EventCallback)
    {
        checkf(ResponseData.RollingImageNoticeId.IsSet(), TEXT("RollingImageNoticeId must not be empty"));
        NoticeId = ResponseData.RollingImageNoticeId.GetValue();
    }

    void Show();
    void Close();
    
private:
    TWeakObjectPtr<UGameInstance> OwningGameInstance;
    FGamebaseImageNoticePreferencesRef Preferences;

    int64 NoticeId;
    
    FGamebaseImageNoticeConfiguration Configuration;
    FGamebaseImageNoticeWeb ResponseData;
    
    FGamebaseErrorDelegate CloseCallback;
    FGamebaseImageNoticeEventDelegate EventCallback;
};
