#pragma once

#include "CoreMinimal.h"
#include "WebSocket/GamebaseWebSocketResponse.h"
#include "ImageNotice/GamebaseImageNoticeConstants.h"

namespace GamebaseImageNotice
{
    struct FResponse final : FGamebaseJsonSerializable
    {
        struct FImageNoticeWeb final : FGamebaseJsonSerializable
        {   
            struct FImageNoticeInfo final : FGamebaseJsonSerializable
            {
                struct FImageInfo final : FGamebaseJsonSerializable
                {
                    int32 Width;
                    int32 Height;
                    
                    BEGIN_GAMEBASE_JSON_SERIALIZER
                        GAMEBASE_JSON_SERIALIZE("width", Width);
                        GAMEBASE_JSON_SERIALIZE("height", Height);
                    END_GAMEBASE_JSON_SERIALIZER
                };
                
                int64 ImageNoticeId;
                TOptional<FString> Path;
                TOptional<FString> ClickScheme;
                FString ClickType;
                FString Theme;
                TOptional<FImageInfo> ImageInfo;
                
                BEGIN_GAMEBASE_JSON_SERIALIZER
                    GAMEBASE_JSON_SERIALIZE("imageNoticeId", ImageNoticeId);
                    GAMEBASE_JSON_SERIALIZE_OPTIONAL("path", Path);
                    GAMEBASE_JSON_SERIALIZE_OPTIONAL("clickScheme", ClickScheme);
                    GAMEBASE_JSON_SERIALIZE("clickType", ClickType);
                    GAMEBASE_JSON_SERIALIZE("theme", Theme);
                    GAMEBASE_JSON_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE("imageInfo", ImageInfo);
                END_GAMEBASE_JSON_SERIALIZER
            };

            FString Type;
            FString Theme;
            bool bHasImageNotice;
            TOptional<int64> RollingImageNoticeId;
            TOptional<int64> NextPopupTimeMillis;
            FString Address;
            int32 FooterHeight;
            TOptional<TArray<FImageNoticeInfo>> PageList;
        
            BEGIN_GAMEBASE_JSON_SERIALIZER
                GAMEBASE_JSON_SERIALIZE("type", Type);
                GAMEBASE_JSON_SERIALIZE("theme", Theme);
                GAMEBASE_JSON_SERIALIZE("hasImageNotice", bHasImageNotice);
                GAMEBASE_JSON_SERIALIZE_OPTIONAL("rollingImageNoticeId", RollingImageNoticeId);
                GAMEBASE_JSON_SERIALIZE_OPTIONAL("nextPopupTimeMillis", NextPopupTimeMillis);
                GAMEBASE_JSON_SERIALIZE("address", Address);
                GAMEBASE_JSON_SERIALIZE("footerHeight", FooterHeight);
                GAMEBASE_JSON_SERIALIZE_OPTIONAL_ARRAY_SERIALIZABLE("pageList", PageList, FImageNoticeInfo);
            END_GAMEBASE_JSON_SERIALIZER

            bool IsValidType() const
            {
                using namespace GamebaseImageNotice;
                return Type.Equals(ViewType::Rolling) || Type.Equals(ViewType::Popup);
            }

            bool IsValidRollingImageNoticeId() const
            {
                using namespace GamebaseImageNotice;
                return RollingImageNoticeId.IsSet() && RollingImageNoticeId.GetValue() != Info::InvalidTime;
            }
        };
        
        FGamebaseHeaderResponse Header;
        FImageNoticeWeb ImageNoticeWeb;

        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("imageNoticeWeb", ImageNoticeWeb);
        END_GAMEBASE_JSON_SERIALIZER
    };
}
