﻿#pragma once

#include "CoreMinimal.h"

namespace GamebaseImageNotice
{
    const FName Domain("GamebaseImageNotice");
    
    namespace Info
    {
        constexpr int64 InvalidTime = -1L;
    }
    
    namespace Scheme
    {   
        const FString CefError = TEXT("cef://error");
        const FString Dismiss = TEXT("gamebase://dismiss");
        const FString ImageNotice = TEXT("gamebase://imagenotice");
        const FString Click = TEXT("gamebase://imagenotice?action=click");
        const FString NaverShowToday = TEXT("gamebase://imagenotice?action=nevershowtoday");

        const TArray<FString> DefaultSchemeList = {
            ImageNotice,
            Dismiss
        };
        
        namespace Action
        {
            const FString Action = TEXT("action");
            const FString Click = TEXT("click");
            const FString Id = TEXT("id");
            const FString NaverShowToday = TEXT("nevershowtoday");
        }
    }

    namespace ViewType
    {
        const FString Rolling = TEXT("ROLLING");
        const FString Popup = TEXT("POPUP");
    }

    namespace ClickType
    {
        const FString None = TEXT("none");
        const FString OpenUrl = TEXT("openUrl");
        const FString Custom = TEXT("custom");   
    }

    namespace Preference
    {
        const FString Key = TEXT("imagenotice.hide.info");
    }
}