#pragma once

#include "GamebaseInternalModule.h"
#include "Interfaces/IGamebaseWebView.h"

class FGamebaseStandaloneEventHandler;

class FGamebaseStandaloneWebView final : public IGamebaseWebView, public FGamebaseInternalModule
{
public:
    explicit FGamebaseStandaloneWebView(const FGamebaseWebSocketPtr& WebSocket,
        const FGamebaseInternalDataPtr& InternalData, const TSharedPtr<FGamebaseStandaloneEventHandler>& EventHandler);
    virtual ~FGamebaseStandaloneWebView() override = default;

    virtual void OpenWebBrowser(const FString& Url) override;

    virtual void ShowWebView(const FString& Url, const FGamebaseWebViewConfiguration& Configuration, const FGamebaseErrorDelegate& CloseCallback,
                             const TArray<FString>& SchemeList, const FGamebaseSchemeEventDelegate& SchemeEvent) override;
    virtual void CloseWebView() override;
    
private:
    void OnEventWebView(int32 EventType);

private:
    TSharedPtr<FGamebaseStandaloneEventHandler> EventHandler;
};
