#include "GamebaseStandaloneUtil.h"

#include "GamebaseDebugLogger.h"

#include "GamebasePopup.h"

using FGamebasePopupButton = GamebasePopup::FGamebasePopupButton;
using FGamebasePopupButtonPtr = GamebasePopup::FGamebasePopupButtonPtr;

void FGamebaseStandaloneUtil::ShowAlert(const FString& Title, const FString& Message)
{
#if PLATFORM_WINDOWS
    GamebasePopup::ShowPopup(Title, Message);
#else
    GAMEBASE_NOT_SUPPORT_API(); 
#endif
}

void FGamebaseStandaloneUtil::ShowAlert(const FString& Title, const FString& Message, const FGamebaseAlertCloseDelegate& CloseCallback)
{
#if PLATFORM_WINDOWS
    GamebasePopup::ShowPopup(Title, Message);
#else
    GAMEBASE_NOT_SUPPORT_API(); 
#endif

    CloseCallback.ExecuteIfBound();
}
void FGamebaseStandaloneUtil::ShowToast(const FString& Message, EGamebaseToastExposureTime ExposureTimeType)
{
    GAMEBASE_NOT_SUPPORT_API();
}

void FGamebaseStandaloneUtil::ShowAlert(TMap<FString, FString> Parameters, const FGamebaseAlertDelegate& Callback)
{
    static const FString KeyTitle(TEXT("KeyTitle"));
    static const FString KeyMessage(TEXT("message"));
    static const FString KeyButtonLeft(TEXT("buttonLeft"));
    static const FString KeyButtonRight(TEXT("buttonRight"));

    const FString Title = Parameters.FindRef(KeyTitle);
    const FString Message = Parameters.FindRef(KeyMessage);
    const FString ButtonLeftName = Parameters.FindRef(KeyButtonLeft);
    const FString ButtonRightName = Parameters.FindRef(KeyButtonRight);
    
#if PLATFORM_WINDOWS
    FGamebasePopupButtonPtr Button1 = nullptr;
    FGamebasePopupButtonPtr Button2 = nullptr;
    if (ButtonLeftName.IsEmpty() == false)
    {
        Button1 = MakeShared<FGamebasePopupButton>(Parameters.FindRef(KeyButtonLeft), [=]
        {
            Callback.ExecuteIfBound(0);
        });

        if (ButtonRightName.IsEmpty() == false)
        {
            Button2 = MakeShared<FGamebasePopupButton>(Parameters.FindRef(KeyButtonRight), [=]
            {
                Callback.ExecuteIfBound(1);
            });
        }
    }
    else
    {
        if (ButtonRightName.IsEmpty() == false)
        {
            Button1 = MakeShared<FGamebasePopupButton>(Parameters.FindRef(KeyButtonRight), [=]
            {
                Callback.ExecuteIfBound(0);
            });
        }
    }
    ShowPopup(Title, Message, Button1, Button2);
#else
    GAMEBASE_NOT_SUPPORT_API(); 
#endif
}
