﻿#pragma once

#include "GamebaseInternalModule.h"
#include "Interfaces/IGamebaseTerms.h"
#include "Types/GamebaseDataContainer.h"
#include "Types/GamebaseTermsTypes.h"

struct FGamebaseAuthToken;

class FGamebaseStandaloneTerms final : public FGamebaseInternalModule, public IGamebaseTerms
{
public:
    explicit FGamebaseStandaloneTerms(const FGamebaseWebSocketPtr& WebSocket, const FGamebaseInternalDataPtr& InternalData)
        : FGamebaseInternalModule(WebSocket, InternalData)
    {
    }

    virtual void ShowTermsView(const FGamebaseDataContainerDelegate& Callback) override;
    virtual void ShowTermsView(const FGamebaseTermsConfiguration& Configuration, const FGamebaseDataContainerDelegate& Callback) override;
    virtual void UpdateTerms(const FGamebaseUpdateTermsConfiguration& Configuration, const FGamebaseErrorDelegate& Callback) override;
    virtual void QueryTerms(const FGamebaseQueryTermsResultDelegate& Callback) override;
    virtual bool IsShowingTermsView() override;
    
    void OnUpdateAuthToken(const TOptional<FGamebaseAuthToken>& AuthToken, const TOptional<FString>& ProviderName = TOptional<FString>());
    
private:
    TOptional<FString> TermsVersion;
};
