﻿#include "GamebaseStandaloneTerms.h"

#include "GamebaseDebugLogger.h"
#include "GamebaseErrorUtil.h"
#include "GamebaseSaveInfo.h"
#include "GamebaseSystemUtils.h"
#include "GamebaseWebSocket.h"
#include "Server/GamebaseServerInfo.h"
#include "Terms/GamebaseTermsDefines.h"
#include "Terms/GamebaseTermsRequest.h"
#include "Terms/GamebaseTermsResponse.h"

void FGamebaseStandaloneTerms::ShowTermsView(const FGamebaseDataContainerDelegate& Callback)
{
    GAMEBASE_NOT_SUPPORT_API();
}

void FGamebaseStandaloneTerms::ShowTermsView(const FGamebaseTermsConfiguration& Configuration, const FGamebaseDataContainerDelegate& Callback)
{
    GAMEBASE_NOT_SUPPORT_API();
}

void FGamebaseStandaloneTerms::UpdateTerms(const FGamebaseUpdateTermsConfiguration& Configuration, const FGamebaseErrorDelegate& Callback)
{
    if (InternalData.IsValid() == false)
    {
        Callback.ExecuteIfBound(GamebaseErrorUtil::NewError(GamebaseTerms::Domain, GamebaseErrorCode::NOT_LOGGED_IN).Get());
        return;
    }
    
    GamebaseTerms::FUpdateParameters Parameters;
    Parameters.UserId = InternalData->GetUserId();
    Parameters.TermsSeq = Configuration.TermsSeq;

    GamebaseTerms::FUpdatePayload Payload;
    for (const auto& Content : Configuration.Contents)
    {
        GamebaseTerms::FUpdatePayload::FContent c;
        c.TermsContentSeq = Content.TermsContentSeq;
        c.bAgreed = Content.bAgreed;
        Payload.Contents.Add(c);
    }
    
    WebSocket->Request(GamebaseServerInfo::TOS::ProductId, GamebaseServerInfo::TOS::Id::UpdateTerms, GamebaseServerInfo::ApiVersion, Parameters, Payload,[=](const FGamebaseWebSocketResponseResult& Response)
    {
        if (Response.IsError())
        {
            Callback.ExecuteIfBound(&Response.GetErrorValue());
            return;
        }

        const auto& ResponseSuccessData = Response.GetOkValue();

        if (ResponseSuccessData.Header.bIsSuccessful)
        {
            if (TermsVersion.IsSet())
            {
                GamebaseSaveInfo::SetStoreValue(InternalData->GetAppId(), GamebaseTerms::Preference::Version, TermsVersion.GetValue());
            }
            
            Callback.ExecuteIfBound(nullptr);
        }
        else
        {
            const FGamebaseErrorPtr RecvError = GamebaseErrorUtil::NewError(ResponseSuccessData, GamebaseTerms::Domain);
            Callback.ExecuteIfBound(RecvError.Get());
        }
    });
}

void FGamebaseStandaloneTerms::QueryTerms(const FGamebaseQueryTermsResultDelegate& Callback)
{
    if (InternalData.IsValid() == false)
    {
        Callback.ExecuteIfBound(nullptr, GamebaseErrorUtil::NewError(GamebaseTerms::Domain, GamebaseErrorCode::NOT_LOGGED_IN).Get());
        return;
    }
    
    GamebaseTerms::FQueryParameters Parameters;
    Parameters.UserId = InternalData->GetUserId();         //-TODO: Unity에서는 값이 없으면 "0"을 넣어주고 있다.
    Parameters.UsimCountryCode = GamebaseSystemUtils::GetSimCode();
    Parameters.DeviceLanguage = GamebaseSystemUtils::GetDeviceLanguage();
    Parameters.DisplayLanguage = InternalData->GetDisplayLanguageCode();
    Parameters.DeviceCountryCode = GamebaseSystemUtils::GetCountryCode();
    
    WebSocket->Request(GamebaseServerInfo::TOS::ProductId, GamebaseServerInfo::TOS::Id::QueryTerms, GamebaseServerInfo::ApiVersion, Parameters, [=](const FGamebaseWebSocketResponseResult& Response)
    {
        if (Response.IsError())
        {
            Callback.ExecuteIfBound(nullptr, &Response.GetErrorValue());
            return;
        }
        
        const auto& ResponseSuccessData = Response.GetOkValue();

        if (ResponseSuccessData.Header.bIsSuccessful)
        {
            GamebaseTerms::FQueryTermsResponse ResponseVo;
            ResponseVo.FromJson(ResponseSuccessData.OriginData);
            
            const FGamebaseQueryTermsResultPtr QueryTermsResult = MakeShared<FGamebaseQueryTermsResult, ESPMode::ThreadSafe>();
            QueryTermsResult->FromJson(ResponseVo.Terms.ToJson());

            if (QueryTermsResult.IsValid())
            {
                TermsVersion.Emplace(QueryTermsResult->TermsVersion);
                Callback.ExecuteIfBound(QueryTermsResult.Get(), nullptr);
            }
            else
            {
                Callback.ExecuteIfBound(nullptr, nullptr);
            }
        }
        else
        {
            const FGamebaseErrorPtr RecvError = GamebaseErrorUtil::NewError(ResponseSuccessData, GamebaseTerms::Domain);
            Callback.ExecuteIfBound(nullptr, RecvError.Get());
        }
    });
}

bool FGamebaseStandaloneTerms::IsShowingTermsView()
{
    GAMEBASE_NOT_SUPPORT_API();
    return false;
}

void FGamebaseStandaloneTerms::OnUpdateAuthToken(const TOptional<FGamebaseAuthToken>& AuthToken, const TOptional<FString>& ProviderName)
{
}