#pragma once

#include "GamebaseAuthTypes.h"
#include "GamebaseInternalDataPointer.h"
#include "Interfaces/IGamebaseSystemInfo.h"

class FGamebaseStandaloneSystemInfo final : public IGamebaseSystemInfo
{
public:
    explicit FGamebaseStandaloneSystemInfo(const FGamebaseInternalDataPtr& InternalData);
    virtual ~FGamebaseStandaloneSystemInfo() override = default;

    virtual void RequestLastLoggedInProvider(const FGamebaseLastLoggedInProviderDelegate& Callback) const override;
    virtual FString GetLastLoggedInProvider() const override;

    virtual FString GetUserID() const override;
    virtual FString GetAccessToken() const override;

    virtual FString GetSDKVersion() const override;
    virtual bool IsSandbox() const override;

    virtual FString GetDisplayLanguageCode() const override;
    virtual void SetDisplayLanguageCode(const FString& LanguageCode) override;
    
    virtual FString GetDeviceLanguageCode() const override;
    virtual FString GetCarrierCode() const override;
    virtual FString GetCarrierName() const override;
    virtual FString GetCountryCode() const override;
    virtual FString GetCountryCodeOfUSIM() const override;
    virtual FString GetCountryCodeOfDevice() const override;
    
private:
    FGamebaseInternalDataPtr InternalData;
};
