#pragma once

#include "GamebaseInternalResult.h"
#include "ShortTermTicket/GamebaseShortTermTicketRequest.h"

using FGamebaseWebSocketPtr = TSharedPtr<class FGamebaseWebSocket>;

DECLARE_DELEGATE_TwoParams(FIssueShortTermTicketDelegate, FString, const FGamebaseError*);

class FGamebaseStandaloneShortTermTicket
{
public:
    
    explicit FGamebaseStandaloneShortTermTicket(const FGamebaseWebSocketPtr& WebSocket)
       : WebSocket(WebSocket)
    {
    }
    ~FGamebaseStandaloneShortTermTicket() = default;

    void IssueShortTermTicket(const GamebaseShortTermTicket::FIssueParameters& Parameter, const FIssueShortTermTicketDelegate& Callback) const;
private:
    FGamebaseWebSocketPtr WebSocket;
};
