#include "GamebaseStandaloneShortTermTicket.h"

#include "ShortTermTicket/GamebaseShortTermTicketConstants.h"
#include "ShortTermTicket/GamebaseShortTermTicketRequest.h"
#include "ShortTermTicket/GamebaseShortTermTicketResponse.h"
#include "GamebaseErrorUtil.h"
#include "GamebaseWebSocket.h"
#include "Server/GamebaseServerInfo.h"

void FGamebaseStandaloneShortTermTicket::IssueShortTermTicket(const GamebaseShortTermTicket::FIssueParameters& Parameter, const FIssueShortTermTicketDelegate& Callback) const
{
    using namespace GamebaseServerInfo;

    FString ApiId = Gateway::Id::IssueShortTermTicket;
    if(Parameter.Purpose == GamebaseShortTermTicket::Purpose::OpenContactForBannedUser)
    {
        ApiId = Gateway::Id::IssueShortTermTicketWithoutLogin;
    }
    
    WebSocket->Request(Gateway::ProductId, ApiId, ApiVersion, Parameter, [=](const FGamebaseWebSocketResponseResult& Response)
    {
        if (Response.IsError())
        {
            Callback.ExecuteIfBound(FString(), &Response.GetErrorValue());
            return;
        }
        
        const auto& ResponseSuccessData = Response.GetOkValue();
        if (ResponseSuccessData.Header.bIsSuccessful)
        {
            GamebaseShortTermTicket::FIssueResponse ResponseVo;
            ResponseVo.FromJson(ResponseSuccessData.OriginData);

            Callback.ExecuteIfBound(ResponseVo.Ticket, nullptr);
        }
        else
        {
            Callback.ExecuteIfBound(FString(), GamebaseErrorUtil::NewError(ResponseSuccessData, GamebaseShortTermTicket::Domain).Get());
        }
    });
}