#pragma once

#include "GamebaseInternalModule.h"
#include "WebSocket/GamebaseWebSocketResponse.h"

class FGamebaseStandaloneEventHandler;

class FGamebaseStandaloneServerPush final : public FGamebaseInternalModule
{
public:
    explicit FGamebaseStandaloneServerPush(const FGamebaseWebSocketPtr& WebSocket,
                                           const FGamebaseInternalDataPtr& InternalData,
                                           const TSharedPtr<FGamebaseStandaloneEventHandler>& EventHandler);
    
    void OnReceiveServerPush(const FGamebaseWebSocketResponse& ServerPushResponse);
    
    DECLARE_MULTICAST_DELEGATE(FStopScheduler);
    FStopScheduler OnStopScheduler;
    
    DECLARE_DELEGATE(FCallLogout);
    FCallLogout OnCallLogout;

private:
    TSharedPtr<FGamebaseStandaloneEventHandler> EventHandler;
    TArray<FString> KickoutStampList;
};
