﻿#pragma once

#include "GamebaseInternalModule.h"
#include "GamebaseInternalResult.h"
#include "Interfaces/IGamebaseLaunching.h"

class FGamebaseStandaloneEventHandler;
class FGamebaseLaunchingScheduler;
struct FGamebaseAuthToken;

DECLARE_DELEGATE_TwoParams(FGetLaunchingStatusDelegate, const int32, const FGamebaseError*);

using FGamebaseLaunchingInfoResult = FGamebaseInternalResult<FGamebaseLaunchingInfo>;
using FGamebaseLaunchingStatusResult = FGamebaseInternalResult<int32>;

class FGamebaseStandaloneLaunching final : public FGamebaseInternalModule, public IGamebaseLaunching
{
public:
    explicit FGamebaseStandaloneLaunching(const FGamebaseWebSocketPtr& WebSocket, const FGamebaseInternalDataPtr& InternalData, const TSharedPtr<FGamebaseStandaloneEventHandler>& EventHandler);
    virtual ~FGamebaseStandaloneLaunching() override;

    virtual const FGamebaseLaunchingInfoPtr GetLaunchingInformations() const override;
    virtual int32 GetLaunchingStatus() const override;

    using FLaunchingInfoFunction = TFunction<void(const FGamebaseLaunchingInfoResult&)>;
    void RequestLaunchingInfo(const FLaunchingInfoFunction& Callback);
    
    using FLaunchingStatusFunction = TFunction<void(const FGamebaseLaunchingStatusResult&)>;
    void RequestGetLaunchingStatusIfNeedUpdate(const FLaunchingStatusFunction& Callback);
    void RequestLaunchingStatus(const FLaunchingStatusFunction& Callback);
    
    void OnUpdateAuthToken(const TOptional<FGamebaseAuthToken>& AuthToken, const TOptional<FString>& ProviderName = TOptional<FString>());

    DECLARE_MULTICAST_DELEGATE_OneParam(FUpdateLaunchingInfoHandler, const FGamebaseLaunchingInfo&);
    FUpdateLaunchingInfoHandler OnUpdateLaunchingInfo;
    
    DECLARE_MULTICAST_DELEGATE_OneParam(FGetLaunchingInfoFailedHandler, const FString&);
    FGetLaunchingInfoFailedHandler OnGetLaunchingInfoFailed;
    
private:
    bool IsNeedUpdate() const;
    
    using FSystemPopupCloseFunction = const TFunction<void()>;
    void ShowNoticePopup(const FGamebaseLaunchingInfo& LaunchingInfo, const FSystemPopupCloseFunction& Callback);
    void ShowStatusPopup(const FGamebaseLaunchingInfo& LaunchingInfo, const FSystemPopupCloseFunction& Callback);
    bool LaunchingError(const FGamebaseError& Error, const FSystemPopupCloseFunction& Callback) const;
    
private:
    TSharedRef<FGamebaseLaunchingScheduler> LaunchingScheduler;
    double LastUpdateTime;
    
    TSharedPtr<FGamebaseStandaloneEventHandler> EventHandler;
};
