﻿#pragma once

#include "GamebaseInternalModule.h"
#include "Scheduler/GamebaseScheduler.h"

struct FGamebaseAuthToken;
struct FGamebaseLaunchingInfo;
class FGamebaseStandaloneEventHandler;

class FGamebaseStandaloneIntrospect final : public FGamebaseInternalModule, public FGamebaseScheduler
{
public:
    explicit FGamebaseStandaloneIntrospect(
        const FGamebaseWebSocketPtr& WebSocket,
        const FGamebaseInternalDataPtr& InternalData,
        const TSharedPtr<FGamebaseStandaloneEventHandler>& EventHandler);
    virtual ~FGamebaseStandaloneIntrospect() override;
    
    void SetIntervalTime(const float InIntervalTime);
    
    void OnUpdateLaunchingInfo(const FGamebaseLaunchingInfo& LaunchingInfo);
    void OnUpdateAuthToken(const TOptional<FGamebaseAuthToken>& AuthToken, const TOptional<FString>& ProviderName = TOptional<FString>());
    
protected:
    virtual void OnStartSchedule() override;
    virtual void OnUpdateSchedule() override;

private:
    int32 RetryCount;
    float SentIntervalTime;
    float SentStandardTime;
    float RetryIntervalTime;
    float RefreshIntervalTime;
    
    TSharedPtr<FGamebaseStandaloneEventHandler> EventHandler;
};
