#pragma once

#include "GamebaseInternalModule.h"
#include "GamebaseStandaloneShortTermTicket.h"
#include "Interfaces/IGamebaseContact.h"
#include "Types/GamebaseContactTypes.h"
#include "Types/GamebaseError.h"

struct FGamebaseContactConfiguration;

class FGamebaseStandaloneContact final : public IGamebaseContact, public FGamebaseInternalModule
{
public:
    explicit FGamebaseStandaloneContact(const FGamebaseWebSocketPtr& WebSocket, const FGamebaseInternalDataPtr& InternalData, const FGamebaseShortTermTicketPtr& ShortTermTicket)
        : FGamebaseInternalModule(WebSocket, InternalData)
        , ShortTermTicket(ShortTermTicket)
    {
    }
    
    virtual void OpenContact(const FGamebaseErrorDelegate& CloseCallback) override;
    virtual void OpenContact(const FGamebaseContactConfiguration& Configuration, const FGamebaseErrorDelegate& CloseCallback) override;
    virtual void RequestContactURL(const FGamebaseContactUrlDelegate& Callback) override;
    virtual void RequestContactURL(const FGamebaseContactConfiguration& Configuration, const FGamebaseContactUrlDelegate& Callback) override;

    void RequestContactURL(const GamebaseShortTermTicket::FIssueParameters& IssueParameter, const TOptional<FGamebaseContactConfiguration>& Configuration, const FGamebaseContactUrlDelegate& Callback) const;
private:
    void RequestContactURLImpl(const TOptional<FGamebaseContactConfiguration>& Configuration, const FGamebaseContactUrlDelegate& Callback) const;

    FGamebaseShortTermTicketPtr ShortTermTicket;
};
