#pragma once

#include "GamebaseInternalModule.h"
#include "Interfaces/IGamebaseAnalytics.h"

struct FGamebaseError;
struct FGamebasePurchasableReceipt;
struct FGamebaseAuthToken;
struct FGamebaseAnalyticsLevelUpData;
struct FGamebaseAnalyticsUserData;

class FGamebaseStandaloneAnalytics final : public IGamebaseAnalytics, public FGamebaseInternalModule
{
public:
    explicit FGamebaseStandaloneAnalytics(const FGamebaseWebSocketPtr& WebSocket, const FGamebaseInternalDataPtr& InternalData)
        : FGamebaseInternalModule(WebSocket, InternalData)
    {
    }

    virtual void SetGameUserData(const FGamebaseAnalyticsUserData& GameUserData) override;
    virtual void TraceLevelUp(const FGamebaseAnalyticsLevelUpData& LevelUpData) override;
    
    void OnUpdateAuthToken(const TOptional<FGamebaseAuthToken>& AuthToken, const TOptional<FString>& ProviderName = TOptional<FString>());
    void OnFinishPurchase(const FString& PaymentSeq);

private:
    FString AccessToken;
    FString UserId;
    FString IdPCode;
    TOptional<FGamebaseAnalyticsUserData> SavedUserData;
};
