#include "GamebaseStandaloneAnalytics.h"

#include "GamebaseDebugLogger.h"
#include "GamebaseInternalReport.h"
#include "GamebaseSystemUtils.h"
#include "GamebaseWebSocket.h"
#include "Analytics/GamebaseAnalyticsRequest.h"
#include "Server/GamebaseServerInfo.h"

void FGamebaseStandaloneAnalytics::SetGameUserData(const FGamebaseAnalyticsUserData& GameUserData)
{
    using namespace GamebaseAnalytics;
    
    if (IsGamebaseLogin() == false)
    {
        GAMEBASE_LOG_ERROR("Current not login.");
        return;
    }
    
    FParameters Parameters;
    Parameters.UserId = InternalData->GetUserId();
    
    FUserMetaPayload Payload;
    Payload.AppId = InternalData->GetAppId();
    Payload.IdPCode = IdPCode;
    Payload.UserMetaData.ChannelId = GameUserData.ChannelId;
    Payload.UserMetaData.CharacterId = GameUserData.CharacterId;
    Payload.UserMetaData.CharacterClassId = GameUserData.CharacterClassId;
    Payload.UserMetaData.UserLevel = GameUserData.UserLevel;
    
    WebSocket->Request(GamebaseServerInfo::Presence::ProductId, GamebaseServerInfo::Presence::Id::SetUserMeta, GamebaseServerInfo::ApiVersion, Parameters, Payload,[=](const FGamebaseWebSocketResponseResult& Response)
    {
        GamebaseInternalReport::TAA::SetGameUserData(*InternalData, GameUserData.UserLevel, GameUserData, Response.TryGetErrorValue());
    });
}

void FGamebaseStandaloneAnalytics::TraceLevelUp(const FGamebaseAnalyticsLevelUpData& LevelUpData)
{
    if (IsGamebaseLogin() == false)
    {
        GAMEBASE_LOG_ERROR("Current not login.");
        return;
    }

    GamebaseAnalytics::FParameters Parameters;
    Parameters.UserId = InternalData->GetUserId();
    
    GamebaseAnalytics::FUserMetaPayload Payload;
    Payload.AppId = InternalData->GetAppId();
    Payload.IdPCode = IdPCode;
    Payload.UserMetaData.UserLevel = LevelUpData.UserLevel;
    Payload.UserMetaData.LevelUpTime = LevelUpData.LevelUpTime;

    WebSocket->Request(GamebaseServerInfo::Presence::ProductId, GamebaseServerInfo::Presence::Id::SetUserMeta, GamebaseServerInfo::ApiVersion, Parameters, Payload,[=](const FGamebaseWebSocketResponseResult& Response)
    {
        GamebaseInternalReport::TAA::TraceLevelUp(*InternalData, LevelUpData.UserLevel, LevelUpData, Response.TryGetErrorValue());
    });
}

void FGamebaseStandaloneAnalytics::OnUpdateAuthToken(const TOptional<FGamebaseAuthToken>& AuthToken, const TOptional<FString>& ProviderName)
{
    if (AuthToken.IsSet())
    {
        // [Gamebase-Client/959]
        if (UserId.IsEmpty() == false && UserId != AuthToken.GetValue().Member.UserId)
        {
        }

        UserId = AuthToken.GetValue().Member.UserId;
        AccessToken = AuthToken.GetValue().Token.AccessToken;
        IdPCode = ProviderName.Get(FString());
    }
    else
    {
        UserId.Reset();
        AccessToken.Reset();
        IdPCode.Reset();
    }
}

void FGamebaseStandaloneAnalytics::OnFinishPurchase(const FString& PaymentSeq)
{
    using namespace GamebaseAnalytics;
    
    if (IsGamebaseLogin() == false)
    {
        GAMEBASE_LOG_ERROR("Current not login.");
        return;
    }
    
    FParameters Parameters;
    Parameters.UserId = InternalData->GetUserId();
    
    FPurchasePayload Payload;
    Payload.AppId = InternalData->GetAppId();
    Payload.ClientVersion = InternalData->GetAppVersion();
    Payload.IdPCode = IdPCode;
    Payload.PaySeq = PaymentSeq;
    Payload.DeviceModel = GamebaseSystemUtils::GetDeviceModel();
    Payload.OSCode = GamebaseSystemUtils::GetPlatform();
    Payload.UsimCountryCode = GamebaseSystemUtils::GetSimCode();
    Payload.DeviceCountryCode = GamebaseSystemUtils::GetCountryCode();
    //Payload.SubStoreCode;

    WebSocket->Request(GamebaseServerInfo::Presence::ProductId,
        GamebaseServerInfo::Presence::Id::CompletePurchase,
        GamebaseServerInfo::ApiVersion,
        Parameters, 
        Payload,
        [this, PaymentSeq](const FGamebaseWebSocketResponseResult& Response)
        {
            const int32 SavedUserLevel = SavedUserData.IsSet() ? SavedUserData.GetValue().UserLevel : 0;
            GamebaseInternalReport::TAA::SendPurchaseCompleteAnalytics(*InternalData, 
                SavedUserLevel, InternalData->GetStoreCode(), PaymentSeq, Response.TryGetErrorValue());
        });
}