#pragma once

#include "GamebaseInternalDataPointer.h"

using FGamebaseWebSocketPtr = TSharedPtr<class FGamebaseWebSocket>;

class FGamebaseInternalModule
{
public:
    explicit FGamebaseInternalModule(const FGamebaseWebSocketPtr& WebSocket, const FGamebaseInternalDataPtr& InternalData)
        : WebSocket(WebSocket)
        , InternalData(InternalData)
    {
    }
    virtual ~FGamebaseInternalModule() = default;

    bool IsInitialize() const;

    bool IsGamebaseLogin() const;

protected:
    FGamebaseWebSocketPtr WebSocket;
    FGamebaseInternalDataPtr InternalData;
};
