﻿#pragma once

#include "GamebaseError.h"

class FGamebaseGameNoticePreferences;

class FGamebaseGameNoticeViewer
{    
public:
    explicit FGamebaseGameNoticeViewer(
        const TWeakObjectPtr<UGameInstance> GameInstance,
        const FString& Url,
        const FGamebaseErrorDelegate& Callback)
        : OwningGameInstance(GameInstance), Url(Url), CloseCallback(Callback)
    {
    }

    void Show();
    
private:
    TWeakObjectPtr<UGameInstance> OwningGameInstance;
    
    FString Url;
    
    FGamebaseErrorDelegate CloseCallback;
};
