﻿#include "GamebaseGameNoticeViewer.h"
#include "GamebaseGameNoticeConstants.h"

#include "GamebaseDebugLogger.h"
#include "GamebaseErrorCode.h"
#include "GamebaseStandaloneSubsystem.h"
#include "WebView/GamebaseWebViewManager.h"
#include "WebView/GamebaseWebViewOpenParams.h"

class UGamebaseStandaloneSubsystem;

void FGamebaseGameNoticeViewer::Show()
{
    if (OwningGameInstance.IsValid() == false)
    {
        GAMEBASE_LOG_GLOBAL_WARNING("OwningGameInstance is invalid.");
        CloseCallback.ExecuteIfBound(&MakeShared<FGamebaseError, ESPMode::ThreadSafe>(GamebaseErrorCode::UNREAL_GET_ENGINE_INFO_ERROR,
            TEXT("OwningGameInstance is invalid."), GamebaseGameNotice::Domain).Get());
        return;
    }
    
    const auto WebViewCloseCallback = FGamebaseErrorDelegate::CreateLambda([this](const FGamebaseError* Error)
    {
        CloseCallback.ExecuteIfBound(Error);
    });
    
    constexpr float ScreenWidth = 1920.f;
    constexpr float ScreenHeight = 1080.f;
    constexpr float StandardWebviewWidth = 575.0f;
    constexpr float StandardWebviewHeight = 700.0f;
    constexpr float NavigationBarHeight = 41.0f;
    
    FGamebaseWebViewOpenParams OpenParams;
    OpenParams.Url = Url;

    FVector2D CurrentViewportSize;
    OwningGameInstance->GetGameViewportClient()->GetViewportSize(CurrentViewportSize);

    const float ScreenW = CurrentViewportSize.X / ScreenWidth;
    const float ScreenH = CurrentViewportSize.Y / ScreenHeight;

    const FVector2D ScreenScale = FVector2D(ScreenW, ScreenH);
    const float Scale = FMath::Min(ScreenScale.X, ScreenScale.Y);

    FVector2D ImageSize = FVector2D(StandardWebviewWidth * Scale, StandardWebviewHeight * Scale);
    ImageSize.Y += NavigationBarHeight;
    
    float Ratio = 1;
    if (ImageSize.X > StandardWebviewWidth)
    {
        Ratio = StandardWebviewWidth / ImageSize.X;
    }
    else if (ImageSize.Y > StandardWebviewHeight)
    {
        Ratio = StandardWebviewHeight / ImageSize.Y;
    }

    ImageSize *= Ratio;
    
    OpenParams.ViewportSize = ImageSize;
    
    OpenParams.BackgroundColor = FColor(0,0,0,128);
    OpenParams.Type = FGamebaseWebViewOpenParams::FloatingPopup;
    
    OpenParams.CloseCallback= [WebViewCloseCallback](const FGamebaseErrorResult& Error)
    {
        WebViewCloseCallback.ExecuteIfBound(nullptr);
    };
    
    if (const UGamebaseStandaloneSubsystem* Subsystem = UGameInstance::GetSubsystem<UGamebaseStandaloneSubsystem>(OwningGameInstance.Get()))
    {
        Subsystem->GetWebViewManager()->Open(OpenParams);
    }
}