#pragma once

class IGamebaseInternalData;
struct FGamebaseContactConfiguration;

namespace GamebaseContact
{
    const FName Domain("GamebaseContact");
    
    namespace CsType
    {
        const FString Gamebase = TEXT("GAMEBASE");
        const FString Toast = TEXT("TOAST");
        const FString Custom = TEXT("CUSTOM");
    }

    struct FToastTypeParameters
    {
        FString Url; 
        FString Ticket;
        FString Purpose;
        FString UserId;
    };
    
    struct FGamebaseTypeParameters
    {
        FString Url; 
        FString Ticket;
        FString Purpose;
        FString UserId;
        FString StoreCode;
        FString AppVersion;
    };

    FString GetCustomCsUrl(const FString& Url, const TOptional<FGamebaseContactConfiguration>& Configuration);
    FString GetToastCsUrlNotLogin(const FString& Url, const TOptional<FGamebaseContactConfiguration>& Configuration);
    FString GetToastCsUrlLogin(const FToastTypeParameters& Parameters, const TOptional<FGamebaseContactConfiguration>& Configuration);
    
    FString GetGamebaseCsUrlNotLogin(const FString& Url, const TOptional<FGamebaseContactConfiguration>& Configuration);
    FString GetGamebaseCsUrl(const FGamebaseTypeParameters& Parameters, const TOptional<FGamebaseContactConfiguration>& Configuration);
}
