﻿#include "GamebaseStandaloneAuthGuest.h"

#include "GamebaseAuthConstants.h"
#include "Constants/GamebaseAuthProvider.h"
#include "Constants/GamebaseAuthProviderCredential.h"
#include "Constants/GamebaseErrorCode.h"

void UGamebaseStandaloneAuthGuest::Initialize(const FGamebaseAuthConfiguration& Configuration)
{
    Super::Initialize(Configuration);
}

void UGamebaseStandaloneAuthGuest::Login(const FGamebaseVariantMap& AdditionalInfo, const FLoginCallback& Callback)
{
    if (AuthConfiguration.GuestAccessToken.IsSet() == false)
    {
        Callback(FGamebaseAuthCredentialsResult(FGamebaseError(GamebaseErrorCode::AUTH_UNKNOWN_ERROR, TEXT("The guest access token is empty."), GamebaseAuth::Domain)));
        return;
    }
    
    FGamebaseAuthCredentials Credentials;
    Credentials.Add(GamebaseAuthProviderCredential::AccessToken, AuthConfiguration.GuestAccessToken.GetValue());
    
    Callback(FGamebaseAuthCredentialsResult(Credentials));
}

void UGamebaseStandaloneAuthGuest::Logout(const FLogoutCallback& Callback)
{
    Callback();
}

void UGamebaseStandaloneAuthGuest::Withdraw(const FWithdrawCallback& Callback)
{
    Callback();
}

FString UGamebaseStandaloneAuthGuest::GetProviderName() const
{
    return GamebaseAuthProvider::Guest;
}

FString UGamebaseStandaloneAuthGuest::GetUserID() const
{
    return {};
}

FString UGamebaseStandaloneAuthGuest::GetAccessToken() const
{
    return {};
}

FGamebaseAuthProviderProfilePtr UGamebaseStandaloneAuthGuest::GetProfile() const
{
    return {};
}

FString UGamebaseStandaloneAuthGuest::GetUniqueKey() const
{
    return GamebaseAuthProvider::Guest;
}
