#pragma once

#include "CoreMinimal.h"
#include "GamebaseJsonSerializerMacros.h"
#include "WebSocket/GamebaseWebSocketResponse.h"

namespace GamebaseAuth
{
    struct FMemberResponse final : FGamebaseJsonSerializable
    {
        struct FAuthMappingInfo final : FGamebaseJsonSerializable
        {
            FString UserId;
            FString AuthSystem;
            FString IdPCode;
            FString AuthKey;
            int64 RegDate;
            
            BEGIN_GAMEBASE_JSON_SERIALIZER
                GAMEBASE_JSON_SERIALIZE("userId", UserId);
                GAMEBASE_JSON_SERIALIZE("authSystem", AuthSystem);
                GAMEBASE_JSON_SERIALIZE("idPCode", IdPCode);
                GAMEBASE_JSON_SERIALIZE("authKey", AuthKey);
                GAMEBASE_JSON_SERIALIZE("regDate", RegDate);
            END_GAMEBASE_JSON_SERIALIZER
        };
        
        struct FTemporaryWithdrawal final : FGamebaseJsonSerializable
        {
            int64 GracePeriodDate;
            
            BEGIN_GAMEBASE_JSON_SERIALIZER
                GAMEBASE_JSON_SERIALIZE("gracePeriodDate", GracePeriodDate);
            END_GAMEBASE_JSON_SERIALIZER
        };

        FString AppId;
        TArray<FAuthMappingInfo> AuthList;
        int64 LastLoginDate;
        int64 RegDate;
        FString UserId;
        FString Valid;
        FTemporaryWithdrawal TemporaryWithdrawal;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("appId", AppId);
            GAMEBASE_JSON_SERIALIZE_ARRAY_SERIALIZABLE("authList", AuthList, FAuthMappingInfo);
            GAMEBASE_JSON_SERIALIZE("lastLoginDate", LastLoginDate);
            GAMEBASE_JSON_SERIALIZE("regDate", RegDate);
            GAMEBASE_JSON_SERIALIZE("userId", UserId);
            GAMEBASE_JSON_SERIALIZE("valid", Valid);
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("temporaryWithdrawal", TemporaryWithdrawal);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FLoginInfoResponse final : FGamebaseJsonSerializable
    {
        struct FToken final : FGamebaseJsonSerializable
        {
            FString AccessToken;
            FString AccessTokenSecret;
            FString SourceIdPCode;
            
            BEGIN_GAMEBASE_JSON_SERIALIZER
                GAMEBASE_JSON_SERIALIZE("accessToken", AccessToken);
                GAMEBASE_JSON_SERIALIZE("accessTokenSecret", AccessTokenSecret);
                GAMEBASE_JSON_SERIALIZE("sourceIdPCode", SourceIdPCode);
            END_GAMEBASE_JSON_SERIALIZER
        };
        
        struct FErrorExtras final : FGamebaseJsonSerializable
        {
            struct FBan final : FGamebaseJsonSerializable
            {
                FString UserId;
                FString BanType;
                int64 BeginDate;
                int64 EndDate;
                FString Message;
                
                BEGIN_GAMEBASE_JSON_SERIALIZER
                    GAMEBASE_JSON_SERIALIZE("userId", UserId);
                    GAMEBASE_JSON_SERIALIZE("accessTokenSecret", BanType);
                    GAMEBASE_JSON_SERIALIZE("beginDate", BeginDate);
                    GAMEBASE_JSON_SERIALIZE("endDate", EndDate);
                    GAMEBASE_JSON_SERIALIZE("message", Message);
                END_GAMEBASE_JSON_SERIALIZER
            };

            FBan Ban;
            
            BEGIN_GAMEBASE_JSON_SERIALIZER
                GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("ban", Ban);
            END_GAMEBASE_JSON_SERIALIZER
        };
        
        FGamebaseHeaderResponse Header;
        FMemberResponse Member;
        FToken Token;
        FErrorExtras ErrorExtras;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("member", Member);
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("token", Token);
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("errorExtras", ErrorExtras);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FTemporaryWithdrawalInfoResponse final : FGamebaseJsonSerializable
    {
        FGamebaseHeaderResponse Header;
        FMemberResponse Member;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("member", Member);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FBindIdPTokenResponse final : FGamebaseJsonSerializable
    {
        FGamebaseHeaderResponse Header;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FIssueSessionTicketResponse final : FGamebaseJsonSerializable
    {
        FGamebaseHeaderResponse Header;
        FString SessionTicketId;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
            GAMEBASE_JSON_SERIALIZE("sessionTicketId", SessionTicketId);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FExchangeSessionResponse final : FGamebaseJsonSerializable
    {
        FGamebaseHeaderResponse Header;
        FString Session;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
        GAMEBASE_JSON_SERIALIZE("session", Session);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FErrorExtras final : FGamebaseJsonSerializable
    {
        FString Ban;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_RAW_JSON_STRING("ban", Ban);
        END_GAMEBASE_JSON_SERIALIZER
    };
}
