#pragma once

#include "CoreMinimal.h"
#include "GamebaseBaseTypes.h"

#include "WebSocket/GamebaseWebSocketRequest.h"

namespace GamebaseAuth
{
    struct FLoginParameters final : FGamebaseBaseParameter
    {
        FString AppId;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("appId", AppId);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FLoginPayload final : FGamebaseBasePayload
    {
        struct FIdpInfo final : FGamebaseJsonSerializable
        {
            TOptional<FString> IdPCode;
            TOptional<FString> SubCode;
            TOptional<FString> AccessToken;
            TOptional<FString> AccessTokenSecret;
            TOptional<FString> AuthorizationCode;
            TOptional<FString> Session;
            TOptional<FString> ClientId;
            TOptional<FString> RedirectUri;
            TOptional<FString> AuthorizationProtocol;
            TOptional<FGamebaseVariantMap> ExtraParams;
            
            BEGIN_GAMEBASE_JSON_SERIALIZER
                GAMEBASE_JSON_SERIALIZE_OPTIONAL("idPCode", IdPCode);
                GAMEBASE_JSON_SERIALIZE_OPTIONAL("subCode", SubCode);
                GAMEBASE_JSON_SERIALIZE_OPTIONAL("accessToken", AccessToken);
                GAMEBASE_JSON_SERIALIZE_OPTIONAL("accessTokenSecret", AccessTokenSecret);
                GAMEBASE_JSON_SERIALIZE_OPTIONAL("authorizationCode", AuthorizationCode);
                GAMEBASE_JSON_SERIALIZE_OPTIONAL("session", Session);
                GAMEBASE_JSON_SERIALIZE_OPTIONAL("clientId", ClientId);
                GAMEBASE_JSON_SERIALIZE_OPTIONAL("redirectUri", RedirectUri);
                GAMEBASE_JSON_SERIALIZE_OPTIONAL("authorizationProtocol", AuthorizationProtocol);
                GAMEBASE_JSON_SERIALIZE_OPTIONAL_VARIANT_MAP("extraParams", ExtraParams);
            END_GAMEBASE_JSON_SERIALIZER
        };
        
        struct FMember final : FGamebaseJsonSerializable
        {
            FString ClientVersion;
            FString SDKVersion;
            FString DeviceCountryCode;
            FString DeviceKey;
            FString DeviceModel;
            FString OSCode;
            FString OSVersion;
            FString DeviceLanguage;
            FString DisplayLanguage;
            FString Network;
            FString StoreCode;
            FString Telecom;
            FString UsimCountryCode;
            FString UUID;
            
            BEGIN_GAMEBASE_JSON_SERIALIZER
                GAMEBASE_JSON_SERIALIZE_STRING("clientVersion", ClientVersion);
                GAMEBASE_JSON_SERIALIZE_STRING("sdkVersion", SDKVersion);
                GAMEBASE_JSON_SERIALIZE_STRING("deviceCountryCode", DeviceCountryCode);
                GAMEBASE_JSON_SERIALIZE_STRING("deviceKey", DeviceKey);
                GAMEBASE_JSON_SERIALIZE_STRING("deviceModel", DeviceModel);
                GAMEBASE_JSON_SERIALIZE_STRING("osCode", OSCode);
                GAMEBASE_JSON_SERIALIZE_STRING("osVersion", OSVersion);
                GAMEBASE_JSON_SERIALIZE_STRING("deviceLanguage", DeviceLanguage);
                GAMEBASE_JSON_SERIALIZE_STRING("displayLanguage", DisplayLanguage);
                GAMEBASE_JSON_SERIALIZE_STRING("network", Network);
                GAMEBASE_JSON_SERIALIZE_STRING("storeCode", StoreCode);
                GAMEBASE_JSON_SERIALIZE_STRING("telecom", Telecom);
                GAMEBASE_JSON_SERIALIZE_STRING("usimCountryCode", UsimCountryCode);
                GAMEBASE_JSON_SERIALIZE_STRING("uuid", UUID);
            END_GAMEBASE_JSON_SERIALIZER
        };

        struct FTokenInfo final : FGamebaseJsonSerializable
        {
            FString IdPCode;
            FString AccessToken;
            TOptional<FString> SubCode;
            TOptional<FGamebaseVariantMap> ExtraParams;
            
            BEGIN_GAMEBASE_JSON_SERIALIZER
                GAMEBASE_JSON_SERIALIZE_STRING("idPCode", IdPCode);
                GAMEBASE_JSON_SERIALIZE_STRING("accessToken", AccessToken);
                GAMEBASE_JSON_SERIALIZE_OPTIONAL("subCode", SubCode);
                GAMEBASE_JSON_SERIALIZE_OPTIONAL_VARIANT_MAP("extraParams", ExtraParams);
            END_GAMEBASE_JSON_SERIALIZER
        };
        
        FIdpInfo IdPInfo;
        FMember Member;
        FTokenInfo TokenInfo;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("idPInfo", IdPInfo);
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("member", Member);
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("tokenInfo", TokenInfo);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FLogoutParameters final : FGamebaseBaseParameter
    {
        FString AppId;
        FString UserId;
        FString AccessToken;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_STRING("appId", AppId);
            GAMEBASE_JSON_SERIALIZE_STRING("userId", UserId);
            GAMEBASE_JSON_SERIALIZE_STRING("accessToken", AccessToken);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FWithdrawParameters final : FGamebaseBaseParameter
    {
        FString UserId;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_STRING("userId", UserId);
        END_GAMEBASE_JSON_SERIALIZER
    };

    struct FBindIdPTokenParameters final : FGamebaseBaseParameter
    {
        FString UserId;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("userId", UserId);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FBindIdPTokenPayload final : FGamebaseBasePayload
    {
        struct FIdpInfo final : FGamebaseJsonSerializable
        {
            FString IdPCode;
            FString Session;
            
            BEGIN_GAMEBASE_JSON_SERIALIZER
                GAMEBASE_JSON_SERIALIZE("idPCode", IdPCode);
                GAMEBASE_JSON_SERIALIZE("session", Session);
            END_GAMEBASE_JSON_SERIALIZER
        };
        
        struct FTokenInfo final : FGamebaseJsonSerializable
        {
            FString AccessToken;
            
            BEGIN_GAMEBASE_JSON_SERIALIZER
                GAMEBASE_JSON_SERIALIZE("accessToken", AccessToken);
            END_GAMEBASE_JSON_SERIALIZER
        };
        
        FIdpInfo IdPInfo;
        FTokenInfo TokenInfo;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("idPInfo", IdPInfo);
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("tokenInfo", TokenInfo);
        END_GAMEBASE_JSON_SERIALIZER
    };

    struct FIssueSessionTicketParameters final : FGamebaseBaseParameter
    {
        int32 ExpiresIn;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("expiresIn", ExpiresIn);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FExchangeSessionTicketParameters final : FGamebaseBaseParameter
    {
        FString SessionTicketId;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("sessionTicketId", SessionTicketId);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FDeleteSessionTicketParameters final : FGamebaseBaseParameter
    {
        FString SessionTicketId;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("sessionTicketId", SessionTicketId);
        END_GAMEBASE_JSON_SERIALIZER
    };
}