﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "GamebaseAuthMemberLoginSystem.h"
#include "GamebaseInternalData.h"

class FGamebaseAuthMemberLoginWithWebView final : public IGamebaseAuthMemberLoginSystem
{
public:
    FGamebaseAuthMemberLoginWithWebView();
    virtual ~FGamebaseAuthMemberLoginWithWebView() override;
    
    virtual void Login(const FGamebaseAuthConfiguration& Configuration, const FGamebaseVariantMap& Queries, const FResponseFunction& Callback) override;
    virtual void CancelLogin(const FCancelLoginCallback& Callback) override;
    
private:
    bool OnAuthWebViewSchemeEvent(const FString& Scheme, const FGamebaseError* Error);
    void CloseWebView();

private:
    FGamebaseInternalDataPtr InternalData;
    FGamebaseAuthLoginResultPtr ResponseData;
    TSharedPtr<SWidget> WebBrowserWidget;
};
