﻿#pragma once

#include "CoreMinimal.h"
#include "GamebaseAuthMemberLoginSystem.h"

class FGamebaseSessionTicketClient;

class FGamebaseAuthMemberLoginWithExternalBrowser final
    : public IGamebaseAuthMemberLoginSystem
    , public TSharedFromThis<FGamebaseAuthMemberLoginWithExternalBrowser, ESPMode::ThreadSafe>
{
    using FSharedThisPtr = TSharedPtr<FGamebaseAuthMemberLoginWithExternalBrowser, ESPMode::ThreadSafe>;
    using FWeakThisPtr = TWeakPtr<FGamebaseAuthMemberLoginWithExternalBrowser, ESPMode::ThreadSafe>;
    
public:
    virtual ~FGamebaseAuthMemberLoginWithExternalBrowser() override;
    
    virtual void Login(const FGamebaseAuthConfiguration& Configuration, const FGamebaseVariantMap& Queries, const FResponseFunction& Callback) override;
    virtual void CancelLogin(const FCancelLoginCallback& Callback) override;

private:
    void StartBrowserMonitoring(const FString& Url, const FGamebaseAuthConfiguration& Configuration, const FResponseFunction& Callback);
    void StartSessionMonitoring(const FGamebaseAuthConfiguration& Configuration, const FResponseFunction& Callback);
    
    void OnBrowserMonitoringFailed();
    void OnBrowserMonitoringClosed();

    void OnSessionMonitoringFailed();
    void OnSessionMonitoringTimeout();

private:
    struct FMonitoringState;
    
    FString SessionTicketId;
    TWeakPtr<FGamebaseSessionTicketClient> SessionTicketClient;
    TSharedPtr<FMonitoringState> MonitoringState;
    FResponseFunction CurrentLoginCallback;
};
