﻿#pragma once

#include "CoreMinimal.h"
#include "GamebaseBaseTypes.h"
#include "GamebaseInternalResult.h"
#include "GamebaseStandaloneAuthTypes.h"

namespace GamebaseAuth
{
    namespace AuthMemberResponseKey
    {
        const FName Session = TEXT("session");
        const FName Token = TEXT("token");
        const FName Code = TEXT("code");
    }

    namespace NeMemberLogin
    {
        FString GetUrl(const FGamebaseAuthConfiguration& Configuration, const FGamebaseVariantMap& Queries, const FString& SvcUrl = {});
    }
}

struct FGamebaseAuthMemberResponseData
{
    TOptional<FString> Session;
    TOptional<FString> Token;
    TOptional<FString> Code;

    FGamebaseAuthMemberResponseData(const TOptional<FString>& Session, const TOptional<FString>& Token, const TOptional<FString>& Code);
    explicit FGamebaseAuthMemberResponseData(const TMap<FString, FString>& Queries);
    
    bool IsValid() const;
};

using FGamebaseAuthLoginResult = FGamebaseInternalResult<FGamebaseAuthMemberResponseData>;
using FGamebaseAuthLoginResultPtr = TSharedPtr<FGamebaseAuthLoginResult>;

class IGamebaseAuthMemberLoginSystem
{   
public:
    virtual ~IGamebaseAuthMemberLoginSystem() = default;
    
    using FResponseFunction = TFunction<void(const FGamebaseAuthLoginResult&)>;
    virtual void Login(const FGamebaseAuthConfiguration& Configuration, const FGamebaseVariantMap& Queries, const FResponseFunction& Callback) = 0;
    
    using FCancelLoginCallback = TFunction<void(const FGamebaseErrorResult&)>;
    virtual void CancelLogin(const FCancelLoginCallback& Callback) = 0;
};